/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsMutateModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsStatsModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsStreamModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsWriteModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.HitsHookGenerator;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmEstimationTemplate;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplateConvenience;
import org.neo4j.gds.applications.algorithms.machinery.MutateNodeProperty;
import org.neo4j.gds.applications.algorithms.machinery.ProgressTrackerCreator;
import org.neo4j.gds.applications.algorithms.machinery.RequestScopedDependencies;
import org.neo4j.gds.applications.algorithms.machinery.WriteContext;
import org.neo4j.gds.logging.Log;

public final class CentralityApplications {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimation;
    private final CentralityAlgorithmsMutateModeBusinessFacade mutation;
    private final CentralityAlgorithmsStatsModeBusinessFacade stats;
    private final CentralityAlgorithmsStreamModeBusinessFacade streaming;
    private final CentralityAlgorithmsWriteModeBusinessFacade writing;

    private CentralityApplications(CentralityAlgorithmsEstimationModeBusinessFacade estimation, CentralityAlgorithmsMutateModeBusinessFacade mutation, CentralityAlgorithmsStatsModeBusinessFacade stats, CentralityAlgorithmsStreamModeBusinessFacade streaming, CentralityAlgorithmsWriteModeBusinessFacade writing) {
        this.estimation = estimation;
        this.mutation = mutation;
        this.stats = stats;
        this.streaming = streaming;
        this.writing = writing;
    }

    public static CentralityApplications create(Log log, RequestScopedDependencies requestScopedDependencies, WriteContext writeContext, AlgorithmEstimationTemplate estimationTemplate, AlgorithmProcessingTemplateConvenience algorithmProcessingTemplateConvenience, ProgressTrackerCreator progressTrackerCreator, MutateNodeProperty mutateNodeProperty) {
        CentralityAlgorithmsEstimationModeBusinessFacade estimation = new CentralityAlgorithmsEstimationModeBusinessFacade(estimationTemplate);
        CentralityAlgorithms algorithms = new CentralityAlgorithms(progressTrackerCreator, requestScopedDependencies.terminationFlag());
        HitsHookGenerator hitsHookGenerator = new HitsHookGenerator(progressTrackerCreator, requestScopedDependencies.terminationFlag());
        CentralityAlgorithmsMutateModeBusinessFacade mutation = new CentralityAlgorithmsMutateModeBusinessFacade(estimation, algorithms, algorithmProcessingTemplateConvenience, mutateNodeProperty, hitsHookGenerator);
        CentralityAlgorithmsStatsModeBusinessFacade stats = new CentralityAlgorithmsStatsModeBusinessFacade(estimation, algorithms, algorithmProcessingTemplateConvenience, hitsHookGenerator);
        CentralityAlgorithmsStreamModeBusinessFacade streaming = new CentralityAlgorithmsStreamModeBusinessFacade(estimation, algorithms, algorithmProcessingTemplateConvenience, hitsHookGenerator);
        CentralityAlgorithmsWriteModeBusinessFacade writing = CentralityAlgorithmsWriteModeBusinessFacade.create(log, requestScopedDependencies, writeContext, estimation, algorithms, algorithmProcessingTemplateConvenience, hitsHookGenerator);
        return new CentralityApplications(estimation, mutation, stats, streaming, writing);
    }

    public CentralityAlgorithmsEstimationModeBusinessFacade estimate() {
        return this.estimation;
    }

    public CentralityAlgorithmsMutateModeBusinessFacade mutate() {
        return this.mutation;
    }

    public CentralityAlgorithmsStatsModeBusinessFacade stats() {
        return this.stats;
    }

    public CentralityAlgorithmsStreamModeBusinessFacade stream() {
        return this.streaming;
    }

    public CentralityAlgorithmsWriteModeBusinessFacade write() {
        return this.writing;
    }
}

