/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.applications.algorithms.machinery.ProgressTrackerCreator;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.loading.PostLoadETLHook;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.hits.HitsConfig;
import org.neo4j.gds.indexInverse.InverseRelationships;
import org.neo4j.gds.indexInverse.InverseRelationshipsConfig;
import org.neo4j.gds.indexInverse.InverseRelationshipsConfigImpl;
import org.neo4j.gds.indexInverse.InverseRelationshipsConfigTransformer;
import org.neo4j.gds.indexInverse.InverseRelationshipsParameters;
import org.neo4j.gds.indexInverse.InverseRelationshipsProgressTaskCreator;
import org.neo4j.gds.termination.TerminationFlag;

class HitsETLHook
implements PostLoadETLHook {
    private final ProgressTrackerCreator progressTrackerCreator;
    private final TerminationFlag terminationFlag;
    private final HitsConfig configuration;

    HitsETLHook(HitsConfig configuration, ProgressTrackerCreator progressTrackerCreator, TerminationFlag terminationFlag) {
        this.progressTrackerCreator = progressTrackerCreator;
        this.configuration = configuration;
        this.terminationFlag = terminationFlag;
    }

    public void onGraphStoreLoaded(GraphStore graphStore) {
        Collection relationshipTypes = this.configuration.internalRelationshipTypes(graphStore);
        List relationshipTypesWithoutIndex = relationshipTypes.stream().filter(relType -> !graphStore.inverseIndexedRelationshipTypes().contains(relType)).map(ElementIdentifier::name).collect(Collectors.toList());
        if (relationshipTypesWithoutIndex.isEmpty()) {
            return;
        }
        InverseRelationshipsConfig inverseConfig = InverseRelationshipsConfigImpl.builder().concurrency((Object)this.configuration.concurrency().value()).relationshipTypes(relationshipTypesWithoutIndex).build();
        InverseRelationshipsParameters parameters = InverseRelationshipsConfigTransformer.toParameters((InverseRelationshipsConfig)inverseConfig);
        Task task = InverseRelationshipsProgressTaskCreator.progressTask((long)graphStore.nodeCount(), (Collection)relationshipTypes);
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)inverseConfig, task);
        InverseRelationships inverseRelationships = new InverseRelationships(graphStore, parameters, progressTracker, DefaultPool.INSTANCE, this.terminationFlag);
        inverseRelationships.compute().forEach((relationshipType, inverseIndex) -> graphStore.addInverseIndex(relationshipType, inverseIndex.topology(), inverseIndex.properties()));
    }
}

