/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValuesAdapter;
import org.neo4j.gds.applications.algorithms.machinery.MutateNodeProperty;
import org.neo4j.gds.applications.algorithms.machinery.MutateStep;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.collections.ha.HugeDoubleArray;
import org.neo4j.gds.hits.HitsConfig;

class HitsMutateStep
implements MutateStep<PregelResult, NodePropertiesWritten> {
    private final MutateNodeProperty mutateNodeProperty;
    private final HitsConfig configuration;

    HitsMutateStep(MutateNodeProperty mutateNodeProperty, HitsConfig configuration) {
        this.mutateNodeProperty = mutateNodeProperty;
        this.configuration = configuration;
    }

    public NodePropertiesWritten execute(Graph graph, GraphStore graphStore, PregelResult result) {
        DoubleNodePropertyValues authValues = NodePropertyValuesAdapter.adapt((HugeDoubleArray)result.nodeValues().doubleProperties(this.configuration.authProperty()));
        DoubleNodePropertyValues hubValues = NodePropertyValuesAdapter.adapt((HugeDoubleArray)result.nodeValues().doubleProperties(this.configuration.authProperty()));
        String authProperty = this.configuration.authProperty().concat(this.configuration.mutateProperty());
        String hubProperty = this.configuration.hubProperty().concat(this.configuration.mutateProperty());
        NodePropertiesWritten authWritten = this.mutate(graph, graphStore, authProperty, (NodePropertyValues)authValues);
        NodePropertiesWritten hubWritten = this.mutate(graph, graphStore, hubProperty, (NodePropertyValues)hubValues);
        return new NodePropertiesWritten(authWritten.value() + hubWritten.value());
    }

    private NodePropertiesWritten mutate(Graph graph, GraphStore graphStore, String mutateProperty, NodePropertyValues values) {
        return this.mutateNodeProperty.mutateNodeProperties(graph, graphStore, this.configuration.nodeLabelIdentifiers(graphStore), mutateProperty, values);
    }
}

