/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import java.util.Map;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.api.properties.nodes.DoubleNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValuesAdapter;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.WriteStep;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.collections.ha.HugeDoubleArray;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.hits.HitsConfig;

class HitsWriteStep
implements WriteStep<PregelResult, NodePropertiesWritten> {
    private final WriteToDatabase writeToDatabase;
    private final HitsConfig configuration;
    private final Label label;

    HitsWriteStep(WriteToDatabase writeToDatabase, HitsConfig configuration, Label label) {
        this.writeToDatabase = writeToDatabase;
        this.configuration = configuration;
        this.label = label;
    }

    public NodePropertiesWritten execute(Graph graph, GraphStore graphStore, ResultStore resultStore, PregelResult result, JobId jobId) {
        return this.writeToDatabase.perform(graph, graphStore, resultStore, (WriteConfig)this.configuration, this.label, jobId, this.nodeProperties(result, this.configuration));
    }

    Map<String, NodePropertyValues> nodeProperties(PregelResult pregelResult, HitsConfig config) {
        DoubleNodePropertyValues authValues = NodePropertyValuesAdapter.adapt((HugeDoubleArray)pregelResult.nodeValues().doubleProperties(config.authProperty()));
        DoubleNodePropertyValues hubValues = NodePropertyValuesAdapter.adapt((HugeDoubleArray)pregelResult.nodeValues().doubleProperties(config.authProperty()));
        String authProperty = config.authProperty().concat(config.writeProperty());
        String hubProperty = config.hubProperty().concat(config.writeProperty());
        return Map.of(authProperty, authValues, hubProperty, hubValues);
    }
}

