/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.applications.algorithms.machinery.MutateNodeProperty;
import org.neo4j.gds.applications.algorithms.machinery.MutateStep;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.indirectExposure.IndirectExposureMutateConfig;
import org.neo4j.gds.indirectExposure.IndirectExposureResult;

class IndirectExposureMutateStep
implements MutateStep<IndirectExposureResult, NodePropertiesWritten> {
    private final MutateNodeProperty mutateNodeProperty;
    private final IndirectExposureMutateConfig config;

    IndirectExposureMutateStep(MutateNodeProperty mutateNodeProperty, IndirectExposureMutateConfig configuration) {
        this.mutateNodeProperty = mutateNodeProperty;
        this.config = configuration;
    }

    public NodePropertiesWritten execute(Graph graph, GraphStore graphStore, IndirectExposureResult result) {
        IndirectExposureMutateConfig.MutateProperties mutateProperties = this.config.mutateProperties();
        NodePropertiesWritten exposuresWritten = this.mutate(graph, graphStore, mutateProperties.exposures(), result.exposureValues());
        NodePropertiesWritten hopsWritten = this.mutate(graph, graphStore, mutateProperties.hops(), result.hopValues());
        NodePropertiesWritten parentsWritten = this.mutate(graph, graphStore, mutateProperties.parents(), result.parentValues());
        NodePropertiesWritten rootsWritten = this.mutate(graph, graphStore, mutateProperties.roots(), result.rootValues());
        return new NodePropertiesWritten(exposuresWritten.value() + hopsWritten.value() + parentsWritten.value() + rootsWritten.value());
    }

    private NodePropertiesWritten mutate(Graph graph, GraphStore graphStore, String mutateProperty, NodePropertyValues values) {
        return this.mutateNodeProperty.mutateNodeProperties(graph, graphStore, this.config.nodeLabelIdentifiers(graphStore), mutateProperty, values);
    }
}

