/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.applications.algorithms.machinery.Label;
import org.neo4j.gds.applications.algorithms.machinery.WriteStep;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.RankConfig;

class PageRankWriteStep<C extends RankConfig & WritePropertyConfig>
implements WriteStep<PageRankResult, NodePropertiesWritten> {
    private final WriteToDatabase writeToDatabase;
    private final C configuration;
    private final Label label;

    PageRankWriteStep(WriteToDatabase writeToDatabase, C configuration, Label label) {
        this.writeToDatabase = writeToDatabase;
        this.configuration = configuration;
        this.label = label;
    }

    public NodePropertiesWritten execute(Graph graph, GraphStore graphStore, ResultStore resultStore, PageRankResult result, JobId jobId) {
        return this.writeToDatabase.perform(graph, graphStore, resultStore, (WriteConfig)this.configuration, (WritePropertyConfig)this.configuration, this.label, jobId, result.nodePropertyValues());
    }
}

