/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.applications.algorithms.machinery.MutateOrWriteStep;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.LabelForProgressTracking;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.influenceMaximization.CELFNodeProperties;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationWriteConfig;

class CelfWriteStep
implements MutateOrWriteStep<CELFResult, NodePropertiesWritten> {
    private final WriteToDatabase writeToDatabase;
    private final InfluenceMaximizationWriteConfig configuration;

    CelfWriteStep(WriteToDatabase writeToDatabase, InfluenceMaximizationWriteConfig configuration) {
        this.writeToDatabase = writeToDatabase;
        this.configuration = configuration;
    }

    public NodePropertiesWritten execute(Graph graph, GraphStore graphStore, ResultStore resultStore, CELFResult result, JobId jobId) {
        CELFNodeProperties nodePropertyValues = new CELFNodeProperties(result.seedSetNodes(), graph.nodeCount());
        return this.writeToDatabase.perform(graph, graphStore, resultStore, (WriteConfig)this.configuration, (WritePropertyConfig)this.configuration, LabelForProgressTracking.CELF, jobId, (NodePropertyValues)nodePropertyValues);
    }
}

