/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import com.carrotsearch.hppc.LongScatterSet;
import com.carrotsearch.hppc.LongSet;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongToDoubleFunction;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmMachinery;
import org.neo4j.gds.applications.algorithms.machinery.ProgressTrackerCreator;
import org.neo4j.gds.applications.algorithms.metadata.LabelForProgressTracking;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.betweenness.BetweennessCentrality;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityParameters;
import org.neo4j.gds.betweenness.BetwennessCentralityResult;
import org.neo4j.gds.betweenness.ForwardTraverser;
import org.neo4j.gds.betweenness.FullSelectionStrategy;
import org.neo4j.gds.betweenness.RandomDegreeSelectionStrategy;
import org.neo4j.gds.betweenness.SelectionStrategy;
import org.neo4j.gds.closeness.CentralityComputer;
import org.neo4j.gds.closeness.ClosenessCentrality;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityParameters;
import org.neo4j.gds.closeness.ClosenessCentralityResult;
import org.neo4j.gds.closeness.DefaultCentralityComputer;
import org.neo4j.gds.closeness.WassermanFaustCentralityComputer;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.concurrency.Concurrency;
import org.neo4j.gds.core.concurrency.DefaultPool;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityParameters;
import org.neo4j.gds.degree.DegreeCentralityResult;
import org.neo4j.gds.degree.DegreeFunction;
import org.neo4j.gds.harmonic.HarmonicCentrality;
import org.neo4j.gds.harmonic.HarmonicCentralityBaseConfig;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.influenceMaximization.CELF;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.pagerank.ArticleRankComputation;
import org.neo4j.gds.pagerank.EigenvectorComputation;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankAlgorithmFactory;
import org.neo4j.gds.pagerank.PageRankComputation;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.termination.TerminationFlag;

public class CentralityAlgorithms {
    private final AlgorithmMachinery algorithmMachinery = new AlgorithmMachinery();
    private final ProgressTrackerCreator progressTrackerCreator;
    private final TerminationFlag terminationFlag;

    public CentralityAlgorithms(ProgressTrackerCreator progressTrackerCreator, TerminationFlag terminationFlag) {
        this.progressTrackerCreator = progressTrackerCreator;
        this.terminationFlag = terminationFlag;
    }

    PageRankResult articleRank(Graph graph, PageRankConfig configuration) {
        return this.pagerank(graph, configuration, LabelForProgressTracking.ArticleRank, PageRankAlgorithmFactory.Mode.ARTICLE_RANK);
    }

    BetwennessCentralityResult betweennessCentrality(Graph graph, BetweennessCentralityBaseConfig configuration) {
        BetweennessCentralityParameters parameters = configuration.toParameters();
        Optional samplingSize = parameters.samplingSize();
        Optional samplingSeed = parameters.samplingSeed();
        FullSelectionStrategy selectionStrategy = samplingSize.isPresent() && (Long)samplingSize.get() < graph.nodeCount() ? new RandomDegreeSelectionStrategy(((Long)samplingSize.get()).longValue(), samplingSeed) : new FullSelectionStrategy();
        ForwardTraverser.Factory traverserFactory = parameters.hasRelationshipWeightProperty() ? ForwardTraverser.Factory.weighted() : ForwardTraverser.Factory.unweighted();
        LeafTask task = Tasks.leaf((String)LabelForProgressTracking.BetweennessCentrality.value, (long)samplingSize.orElse(graph.nodeCount()));
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, (Task)task);
        BetweennessCentrality algorithm = new BetweennessCentrality(graph, (SelectionStrategy)selectionStrategy, traverserFactory, DefaultPool.INSTANCE, parameters.concurrency(), progressTracker, this.terminationFlag);
        return (BetwennessCentralityResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true);
    }

    CELFResult celf(Graph graph, InfluenceMaximizationBaseConfig configuration) {
        Task task = Tasks.task((String)LabelForProgressTracking.CELF.value, (Task)Tasks.leaf((String)"Greedy", (long)graph.nodeCount()), (Task[])new Task[]{Tasks.leaf((String)"LazyForwarding", (long)(configuration.seedSetSize() - 1))});
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        CELF algorithm = new CELF(graph, configuration.toParameters(), DefaultPool.INSTANCE, progressTracker);
        return (CELFResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true);
    }

    ClosenessCentralityResult closenessCentrality(Graph graph, ClosenessCentralityBaseConfig configuration) {
        ClosenessCentralityParameters parameters = configuration.toParameters();
        WassermanFaustCentralityComputer centralityComputer = parameters.useWassermanFaust() ? new WassermanFaustCentralityComputer(graph.nodeCount()) : new DefaultCentralityComputer();
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, Tasks.task((String)LabelForProgressTracking.ClosenessCentrality.value, (Task)Tasks.leaf((String)"Farness computation", (long)(graph.nodeCount() * graph.nodeCount())), (Task[])new Task[]{Tasks.leaf((String)"Closeness computation", (long)graph.nodeCount())}));
        ClosenessCentrality algorithm = new ClosenessCentrality(graph, parameters.concurrency(), (CentralityComputer)centralityComputer, DefaultPool.INSTANCE, progressTracker);
        return (ClosenessCentralityResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true);
    }

    DegreeCentralityResult degreeCentrality(Graph graph, DegreeCentralityConfig configuration) {
        DegreeCentralityParameters parameters = configuration.toParameters();
        LeafTask task = Tasks.leaf((String)LabelForProgressTracking.DegreeCentrality.value, (long)graph.nodeCount());
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, (Task)task);
        DegreeCentrality algorithm = new DegreeCentrality(graph, DefaultPool.INSTANCE, parameters.concurrency(), parameters.orientation(), parameters.hasRelationshipWeightProperty(), parameters.minBatchSize(), progressTracker);
        return (DegreeCentralityResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true);
    }

    PageRankResult eigenVector(Graph graph, PageRankConfig configuration) {
        return this.pagerank(graph, configuration, LabelForProgressTracking.EigenVector, PageRankAlgorithmFactory.Mode.EIGENVECTOR);
    }

    HarmonicResult harmonicCentrality(Graph graph, HarmonicCentralityBaseConfig configuration) {
        LeafTask task = Tasks.leaf((String)LabelForProgressTracking.HarmonicCentrality.value);
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, (Task)task);
        HarmonicCentrality algorithm = new HarmonicCentrality(graph, configuration.concurrency(), DefaultPool.INSTANCE, progressTracker);
        return (HarmonicResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true);
    }

    PageRankResult pageRank(Graph graph, PageRankConfig configuration) {
        return this.pagerank(graph, configuration, LabelForProgressTracking.PageRank, PageRankAlgorithmFactory.Mode.PAGE_RANK);
    }

    private double averageDegree(Graph graph, Concurrency concurrency) {
        LongAdder degreeSum = new LongAdder();
        ParallelUtil.parallelForEachNode((long)graph.nodeCount(), (Concurrency)concurrency, (TerminationFlag)TerminationFlag.RUNNING_TRUE, nodeId -> degreeSum.add(graph.degree(nodeId)));
        return (double)degreeSum.sum() / (double)graph.nodeCount();
    }

    private LongToDoubleFunction degreeFunction(Graph graph, PageRankConfig configuration) {
        DegreeCentrality degreeCentrality = new DegreeCentrality(graph, DefaultPool.INSTANCE, configuration.concurrency(), Orientation.NATURAL, configuration.hasRelationshipWeightProperty(), 10000, ProgressTracker.NULL_TRACKER);
        DegreeFunction degrees = degreeCentrality.compute().degreeFunction();
        return arg_0 -> ((DegreeFunction)degrees).get(arg_0);
    }

    private PageRankResult pagerank(Graph graph, PageRankConfig configuration, LabelForProgressTracking label, PageRankAlgorithmFactory.Mode mode) {
        Task task = Pregel.progressTask((Graph)graph, (PregelConfig)configuration, (String)label.value);
        ProgressTracker progressTracker = this.progressTrackerCreator.createProgressTracker((AlgoBaseConfig)configuration, task);
        PregelComputation<PageRankConfig> computation = this.pickComputation(graph, configuration, mode);
        PageRankAlgorithm algorithm = new PageRankAlgorithm(graph, configuration, computation, mode, DefaultPool.INSTANCE, progressTracker, this.terminationFlag);
        return (PageRankResult)this.algorithmMachinery.runAlgorithmsAndManageProgressTracker((Algorithm)algorithm, progressTracker, true);
    }

    private PregelComputation<PageRankConfig> pickComputation(Graph graph, PageRankConfig configuration, PageRankAlgorithmFactory.Mode mode) {
        LongToDoubleFunction degreeFunction = this.degreeFunction(graph, configuration);
        LongScatterSet mappedSourceNodes = new LongScatterSet(configuration.sourceNodes().size());
        configuration.sourceNodes().stream().mapToLong(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).forEach(arg_0 -> ((LongScatterSet)mappedSourceNodes).add(arg_0));
        if (mode == PageRankAlgorithmFactory.Mode.ARTICLE_RANK) {
            double avgDegree = this.averageDegree(graph, configuration.concurrency());
            return new ArticleRankComputation(configuration, (LongSet)mappedSourceNodes, degreeFunction, avgDegree);
        }
        if (mode == PageRankAlgorithmFactory.Mode.EIGENVECTOR) {
            degreeFunction = configuration.hasRelationshipWeightProperty() ? degreeFunction : nodeId -> 1.0;
            return new EigenvectorComputation(graph.nodeCount(), configuration, (LongSet)mappedSourceNodes, degreeFunction);
        }
        return new PageRankComputation(configuration, (LongSet)mappedSourceNodes, degreeFunction);
    }
}

