/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.applications.algorithms.machinery.AlgorithmEstimationTemplate;
import org.neo4j.gds.applications.algorithms.machinery.MemoryEstimateResult;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityMemoryEstimateDefinition;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityAlgorithmEstimateDefinition;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.influenceMaximization.CELFMemoryEstimateDefinition;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.mem.MemoryEstimation;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankMemoryEstimateDefinition;

public class CentralityAlgorithmsEstimationModeBusinessFacade {
    private final AlgorithmEstimationTemplate algorithmEstimationTemplate;

    public CentralityAlgorithmsEstimationModeBusinessFacade(AlgorithmEstimationTemplate algorithmEstimationTemplate) {
        this.algorithmEstimationTemplate = algorithmEstimationTemplate;
    }

    public MemoryEstimation betweennessCentrality(RelationshipWeightConfig configuration) {
        return new BetweennessCentralityMemoryEstimateDefinition(configuration.hasRelationshipWeightProperty()).memoryEstimation();
    }

    public MemoryEstimateResult betweennessCentrality(BetweennessCentralityBaseConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.betweennessCentrality((RelationshipWeightConfig)configuration);
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation celf(InfluenceMaximizationBaseConfig configuration) {
        return new CELFMemoryEstimateDefinition(configuration.toParameters()).memoryEstimation();
    }

    public MemoryEstimateResult celf(InfluenceMaximizationBaseConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.celf(configuration);
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation closenessCentrality(ClosenessCentralityBaseConfig ignored) {
        throw new MemoryEstimationNotImplementedException();
    }

    public MemoryEstimation degreeCentrality(RelationshipWeightConfig configuration) {
        return new DegreeCentralityAlgorithmEstimateDefinition(configuration.hasRelationshipWeightProperty()).memoryEstimation();
    }

    public MemoryEstimateResult degreeCentrality(DegreeCentralityConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.degreeCentrality((RelationshipWeightConfig)configuration);
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }

    public MemoryEstimation harmonicCentrality() {
        throw new MemoryEstimationNotImplementedException();
    }

    public MemoryEstimation pageRank() {
        return new PageRankMemoryEstimateDefinition().memoryEstimation();
    }

    public MemoryEstimateResult pageRank(PageRankConfig configuration, Object graphNameOrConfiguration) {
        MemoryEstimation memoryEstimation = this.pageRank();
        return this.algorithmEstimationTemplate.estimate((AlgoBaseConfig)configuration, graphNameOrConfiguration, memoryEstimation);
    }
}

