/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import java.util.Optional;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.BetweennessCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.CelfMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.ClosenessCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.DegreeCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.HarmonicCentralityMutateStep;
import org.neo4j.gds.applications.algorithms.centrality.PageRankMutateStep;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplate;
import org.neo4j.gds.applications.algorithms.machinery.MutateNodeProperty;
import org.neo4j.gds.applications.algorithms.machinery.ResultBuilder;
import org.neo4j.gds.applications.algorithms.metadata.LabelForProgressTracking;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityMutateConfig;
import org.neo4j.gds.betweenness.BetwennessCentralityResult;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityMutateConfig;
import org.neo4j.gds.closeness.ClosenessCentralityResult;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityMutateConfig;
import org.neo4j.gds.degree.DegreeCentralityResult;
import org.neo4j.gds.harmonic.HarmonicCentralityBaseConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityMutateConfig;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationMutateConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankMutateConfig;
import org.neo4j.gds.pagerank.PageRankResult;

public class CentralityAlgorithmsMutateModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimation;
    private final CentralityAlgorithms algorithms;
    private final AlgorithmProcessingTemplate template;
    private final MutateNodeProperty mutateNodeProperty;

    public CentralityAlgorithmsMutateModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimation, CentralityAlgorithms algorithms, AlgorithmProcessingTemplate template, MutateNodeProperty mutateNodeProperty) {
        this.estimation = estimation;
        this.algorithms = algorithms;
        this.template = template;
        this.mutateNodeProperty = mutateNodeProperty;
    }

    public <RESULT> RESULT articleRank(GraphName graphName, PageRankMutateConfig configuration, ResultBuilder<PageRankMutateConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankMutateStep mutateStep = new PageRankMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.ArticleRank, this.estimation::pageRank, graph -> this.algorithms.articleRank(graph, (PageRankConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT betweennessCentrality(GraphName graphName, BetweennessCentralityMutateConfig configuration, ResultBuilder<BetweennessCentralityMutateConfig, BetwennessCentralityResult, RESULT, NodePropertiesWritten> resultBuilder) {
        BetweennessCentralityMutateStep mutateStep = new BetweennessCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.BetweennessCentrality, () -> this.estimation.betweennessCentrality((RelationshipWeightConfig)configuration), graph -> this.algorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT celf(GraphName graphName, InfluenceMaximizationMutateConfig configuration, ResultBuilder<InfluenceMaximizationMutateConfig, CELFResult, RESULT, NodePropertiesWritten> resultBuilder) {
        CelfMutateStep mutateStep = new CelfMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.CELF, () -> this.estimation.celf((InfluenceMaximizationBaseConfig)configuration), graph -> this.algorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT closenessCentrality(GraphName graphName, ClosenessCentralityMutateConfig configuration, ResultBuilder<ClosenessCentralityMutateConfig, ClosenessCentralityResult, RESULT, NodePropertiesWritten> resultBuilder) {
        ClosenessCentralityMutateStep mutateStep = new ClosenessCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.ClosenessCentrality, () -> this.estimation.closenessCentrality((ClosenessCentralityBaseConfig)configuration), graph -> this.algorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT degreeCentrality(GraphName graphName, DegreeCentralityMutateConfig configuration, ResultBuilder<DegreeCentralityMutateConfig, DegreeCentralityResult, RESULT, NodePropertiesWritten> resultBuilder) {
        DegreeCentralityMutateStep mutateStep = new DegreeCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.DegreeCentrality, () -> this.estimation.degreeCentrality((RelationshipWeightConfig)configuration), graph -> this.algorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT eigenVector(GraphName graphName, PageRankMutateConfig configuration, ResultBuilder<PageRankMutateConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankMutateStep mutateStep = new PageRankMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.EigenVector, this.estimation::pageRank, graph -> this.algorithms.eigenVector(graph, (PageRankConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT harmonicCentrality(GraphName graphName, HarmonicCentralityMutateConfig configuration, ResultBuilder<HarmonicCentralityMutateConfig, HarmonicResult, RESULT, NodePropertiesWritten> resultBuilder) {
        HarmonicCentralityMutateStep mutateStep = new HarmonicCentralityMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.HarmonicCentrality, this.estimation::harmonicCentrality, graph -> this.algorithms.harmonicCentrality(graph, (HarmonicCentralityBaseConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }

    public <RESULT> RESULT pageRank(GraphName graphName, PageRankMutateConfig configuration, ResultBuilder<PageRankMutateConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankMutateStep mutateStep = new PageRankMutateStep(this.mutateNodeProperty, configuration);
        return (RESULT)this.template.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.PageRank, this.estimation::pageRank, graph -> this.algorithms.pageRank(graph, (PageRankConfig)configuration), Optional.of(mutateStep), resultBuilder);
    }
}

