/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import java.util.Optional;
import org.neo4j.gds.algorithms.centrality.CentralityAlgorithmResult;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplate;
import org.neo4j.gds.applications.algorithms.machinery.ResultBuilder;
import org.neo4j.gds.applications.algorithms.metadata.LabelForProgressTracking;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityStatsConfig;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityStatsConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityStatsConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityBaseConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityStatsConfig;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationStatsConfig;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankStatsConfig;

public class CentralityAlgorithmsStatsModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade;
    private final CentralityAlgorithms centralityAlgorithms;
    private final AlgorithmProcessingTemplate algorithmProcessingTemplate;

    public CentralityAlgorithmsStatsModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplate algorithmProcessingTemplate) {
        this.estimationFacade = estimationFacade;
        this.centralityAlgorithms = centralityAlgorithms;
        this.algorithmProcessingTemplate = algorithmProcessingTemplate;
    }

    public <RESULT> RESULT articleRank(GraphName graphName, PageRankStatsConfig configuration, ResultBuilder<PageRankStatsConfig, PageRankResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.ArticleRank, this.estimationFacade::pageRank, graph -> this.centralityAlgorithms.articleRank(graph, (PageRankConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT betweennessCentrality(GraphName graphName, BetweennessCentralityStatsConfig configuration, ResultBuilder<BetweennessCentralityStatsConfig, CentralityAlgorithmResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.BetweennessCentrality, () -> this.estimationFacade.betweennessCentrality((RelationshipWeightConfig)configuration), graph -> this.centralityAlgorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT celf(GraphName graphName, InfluenceMaximizationStatsConfig configuration, ResultBuilder<InfluenceMaximizationStatsConfig, CELFResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.CELF, () -> this.estimationFacade.celf((InfluenceMaximizationBaseConfig)configuration), graph -> this.centralityAlgorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT closenessCentrality(GraphName graphName, ClosenessCentralityStatsConfig configuration, ResultBuilder<ClosenessCentralityStatsConfig, CentralityAlgorithmResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.ClosenessCentrality, () -> this.estimationFacade.closenessCentrality((ClosenessCentralityBaseConfig)configuration), graph -> this.centralityAlgorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT degreeCentrality(GraphName graphName, DegreeCentralityStatsConfig configuration, ResultBuilder<DegreeCentralityStatsConfig, CentralityAlgorithmResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.DegreeCentrality, () -> this.estimationFacade.degreeCentrality((RelationshipWeightConfig)configuration), graph -> this.centralityAlgorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT eigenVector(GraphName graphName, PageRankStatsConfig configuration, ResultBuilder<PageRankStatsConfig, PageRankResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.EigenVector, this.estimationFacade::pageRank, graph -> this.centralityAlgorithms.eigenVector(graph, (PageRankConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT harmonicCentrality(GraphName graphName, HarmonicCentralityStatsConfig configuration, ResultBuilder<HarmonicCentralityStatsConfig, CentralityAlgorithmResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.HarmonicCentrality, this.estimationFacade::harmonicCentrality, graph -> this.centralityAlgorithms.harmonicCentrality(graph, (HarmonicCentralityBaseConfig)configuration), Optional.empty(), resultBuilder);
    }

    public <RESULT> RESULT pageRank(GraphName graphName, PageRankStatsConfig configuration, ResultBuilder<PageRankStatsConfig, PageRankResult, RESULT, Void> resultBuilder) {
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.PageRank, this.estimationFacade::pageRank, graph -> this.centralityAlgorithms.pageRank(graph, (PageRankConfig)configuration), Optional.empty(), resultBuilder);
    }
}

