/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import java.util.Optional;
import org.neo4j.gds.algorithms.centrality.CentralityAlgorithmResult;
import org.neo4j.gds.api.GraphName;
import org.neo4j.gds.applications.algorithms.centrality.BetweennessCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.CelfWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithms;
import org.neo4j.gds.applications.algorithms.centrality.CentralityAlgorithmsEstimationModeBusinessFacade;
import org.neo4j.gds.applications.algorithms.centrality.ClosenessCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.DegreeCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.HarmonicCentralityWriteStep;
import org.neo4j.gds.applications.algorithms.centrality.PageRankWriteStep;
import org.neo4j.gds.applications.algorithms.machinery.AlgorithmProcessingTemplate;
import org.neo4j.gds.applications.algorithms.machinery.RequestScopedDependencies;
import org.neo4j.gds.applications.algorithms.machinery.ResultBuilder;
import org.neo4j.gds.applications.algorithms.machinery.WriteNodePropertyService;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.LabelForProgressTracking;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.betweenness.BetweennessCentralityBaseConfig;
import org.neo4j.gds.betweenness.BetweennessCentralityWriteConfig;
import org.neo4j.gds.closeness.ClosenessCentralityBaseConfig;
import org.neo4j.gds.closeness.ClosenessCentralityWriteConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityWriteConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityBaseConfig;
import org.neo4j.gds.harmonic.HarmonicCentralityWriteConfig;
import org.neo4j.gds.harmonic.HarmonicResult;
import org.neo4j.gds.influenceMaximization.CELFResult;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationBaseConfig;
import org.neo4j.gds.influenceMaximization.InfluenceMaximizationWriteConfig;
import org.neo4j.gds.logging.Log;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankWriteConfig;

public final class CentralityAlgorithmsWriteModeBusinessFacade {
    private final CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade;
    private final CentralityAlgorithms centralityAlgorithms;
    private final AlgorithmProcessingTemplate algorithmProcessingTemplate;
    private final WriteToDatabase writeToDatabase;

    private CentralityAlgorithmsWriteModeBusinessFacade(CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplate algorithmProcessingTemplate, WriteToDatabase writeToDatabase) {
        this.estimationFacade = estimationFacade;
        this.centralityAlgorithms = centralityAlgorithms;
        this.algorithmProcessingTemplate = algorithmProcessingTemplate;
        this.writeToDatabase = writeToDatabase;
    }

    public static CentralityAlgorithmsWriteModeBusinessFacade create(Log log, RequestScopedDependencies requestScopedDependencies, CentralityAlgorithmsEstimationModeBusinessFacade estimationFacade, CentralityAlgorithms centralityAlgorithms, AlgorithmProcessingTemplate algorithmProcessingTemplate) {
        WriteNodePropertyService writeNodePropertyService = new WriteNodePropertyService(log, requestScopedDependencies);
        WriteToDatabase writeToDatabase = new WriteToDatabase(writeNodePropertyService);
        return new CentralityAlgorithmsWriteModeBusinessFacade(estimationFacade, centralityAlgorithms, algorithmProcessingTemplate, writeToDatabase);
    }

    public <RESULT> RESULT articleRank(GraphName graphName, PageRankWriteConfig configuration, ResultBuilder<PageRankWriteConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankWriteStep writeStep = new PageRankWriteStep(this.writeToDatabase, configuration, LabelForProgressTracking.ArticleRank);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.ArticleRank, this.estimationFacade::pageRank, graph -> this.centralityAlgorithms.articleRank(graph, (PageRankConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <RESULT> RESULT betweennessCentrality(GraphName graphName, BetweennessCentralityWriteConfig configuration, ResultBuilder<BetweennessCentralityWriteConfig, CentralityAlgorithmResult, RESULT, NodePropertiesWritten> resultBuilder) {
        BetweennessCentralityWriteStep writeStep = new BetweennessCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.BetweennessCentrality, () -> this.estimationFacade.betweennessCentrality((RelationshipWeightConfig)configuration), graph -> this.centralityAlgorithms.betweennessCentrality(graph, (BetweennessCentralityBaseConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <CONFIGURATION extends InfluenceMaximizationWriteConfig, RESULT> RESULT celf(GraphName graphName, CONFIGURATION configuration, ResultBuilder<CONFIGURATION, CELFResult, RESULT, NodePropertiesWritten> resultBuilder) {
        CelfWriteStep writeStep = new CelfWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, configuration, LabelForProgressTracking.CELF, () -> this.estimationFacade.celf((InfluenceMaximizationBaseConfig)configuration), graph -> this.centralityAlgorithms.celf(graph, (InfluenceMaximizationBaseConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <RESULT> RESULT closenessCentrality(GraphName graphName, ClosenessCentralityWriteConfig configuration, ResultBuilder<ClosenessCentralityWriteConfig, CentralityAlgorithmResult, RESULT, NodePropertiesWritten> resultBuilder) {
        ClosenessCentralityWriteStep writeStep = new ClosenessCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.ClosenessCentrality, () -> this.estimationFacade.closenessCentrality((ClosenessCentralityBaseConfig)configuration), graph -> this.centralityAlgorithms.closenessCentrality(graph, (ClosenessCentralityBaseConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <RESULT> RESULT degreeCentrality(GraphName graphName, DegreeCentralityWriteConfig configuration, ResultBuilder<DegreeCentralityWriteConfig, CentralityAlgorithmResult, RESULT, NodePropertiesWritten> resultBuilder) {
        DegreeCentralityWriteStep writeStep = new DegreeCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.DegreeCentrality, () -> this.estimationFacade.degreeCentrality((RelationshipWeightConfig)configuration), graph -> this.centralityAlgorithms.degreeCentrality(graph, (DegreeCentralityConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <RESULT> RESULT eigenvector(GraphName graphName, PageRankWriteConfig configuration, ResultBuilder<PageRankWriteConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankWriteStep writeStep = new PageRankWriteStep(this.writeToDatabase, configuration, LabelForProgressTracking.EigenVector);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.EigenVector, this.estimationFacade::pageRank, graph -> this.centralityAlgorithms.eigenVector(graph, (PageRankConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <CONFIGURATION extends HarmonicCentralityWriteConfig, RESULT> RESULT harmonicCentrality(GraphName graphName, CONFIGURATION configuration, ResultBuilder<CONFIGURATION, HarmonicResult, RESULT, NodePropertiesWritten> resultBuilder) {
        HarmonicCentralityWriteStep writeStep = new HarmonicCentralityWriteStep(this.writeToDatabase, configuration);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, configuration, LabelForProgressTracking.HarmonicCentrality, this.estimationFacade::harmonicCentrality, graph -> this.centralityAlgorithms.harmonicCentrality(graph, (HarmonicCentralityBaseConfig)configuration), Optional.of(writeStep), resultBuilder);
    }

    public <RESULT> RESULT pageRank(GraphName graphName, PageRankWriteConfig configuration, ResultBuilder<PageRankWriteConfig, PageRankResult, RESULT, NodePropertiesWritten> resultBuilder) {
        PageRankWriteStep writeStep = new PageRankWriteStep(this.writeToDatabase, configuration, LabelForProgressTracking.ArticleRank);
        return (RESULT)this.algorithmProcessingTemplate.processAlgorithm(graphName, (AlgoBaseConfig)configuration, LabelForProgressTracking.PageRank, this.estimationFacade::pageRank, graph -> this.centralityAlgorithms.pageRank(graph, (PageRankConfig)configuration), Optional.of(writeStep), resultBuilder);
    }
}

