/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.applications.algorithms.centrality;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.ResultStore;
import org.neo4j.gds.applications.algorithms.machinery.MutateOrWriteStep;
import org.neo4j.gds.applications.algorithms.machinery.WriteToDatabase;
import org.neo4j.gds.applications.algorithms.metadata.LabelForProgressTracking;
import org.neo4j.gds.applications.algorithms.metadata.NodePropertiesWritten;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.pagerank.PageRankResult;
import org.neo4j.gds.pagerank.PageRankWriteConfig;

class PageRankWriteStep
implements MutateOrWriteStep<PageRankResult, NodePropertiesWritten> {
    private final WriteToDatabase writeToDatabase;
    private final PageRankWriteConfig configuration;
    private final LabelForProgressTracking label;

    PageRankWriteStep(WriteToDatabase writeToDatabase, PageRankWriteConfig configuration, LabelForProgressTracking label) {
        this.writeToDatabase = writeToDatabase;
        this.configuration = configuration;
        this.label = label;
    }

    public NodePropertiesWritten execute(Graph graph, GraphStore graphStore, ResultStore resultStore, PageRankResult result, JobId jobId) {
        return this.writeToDatabase.perform(graph, graphStore, resultStore, (WriteConfig)this.configuration, (WritePropertyConfig)this.configuration, this.label, jobId, result.nodePropertyValues());
    }
}

