/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.gds.configuration.Default;

public class DefaultsConfiguration {
    public static final DefaultsConfiguration Instance = new DefaultsConfiguration(new HashMap<String, Default>(), new HashMap<String, Map<String, Default>>());
    public static final DefaultsConfiguration Empty = new DefaultsConfiguration(Collections.emptyMap(), Collections.emptyMap());
    private final Map<String, Default> globalDefaults;
    private final Map<String, Map<String, Default>> personalDefaults;

    public DefaultsConfiguration(Map<String, Default> globalDefaults, Map<String, Map<String, Default>> personalDefaults) {
        this.globalDefaults = globalDefaults;
        this.personalDefaults = personalDefaults;
    }

    public Map<String, Object> apply(Map<String, Object> configuration, String username) {
        HashMap<String, Object> configurationWithDefaults = new HashMap<String, Object>(configuration);
        this.startWithPersonalDefaults(username, configurationWithDefaults);
        this.fillInWithGlobalDefaults(configurationWithDefaults);
        return configurationWithDefaults;
    }

    public Map<String, Object> list(Optional<String> username, Optional<String> key) {
        Map<String, Object> defaults = this.startWithGlobalDefaults();
        this.overlayPersonalDefaultsIfApplicable(username, defaults);
        if (key.isEmpty()) {
            return defaults;
        }
        if (!defaults.containsKey(key.get())) {
            return Collections.emptyMap();
        }
        Object value = defaults.get(key.get());
        return Map.of(key.get(), value);
    }

    public void set(String key, Object value, Optional<String> username) {
        Default valueAsDefault = new Default(value);
        if (username.isPresent()) {
            this.personalDefaults.putIfAbsent(username.get(), new HashMap());
            this.personalDefaults.get(username.get()).put(key, valueAsDefault);
        } else {
            this.globalDefaults.put(key, valueAsDefault);
        }
    }

    private void fillInWithGlobalDefaults(Map<String, Object> configurationWithDefaults) {
        this.globalDefaults.forEach((s, d) -> configurationWithDefaults.putIfAbsent((String)s, d.getValue()));
    }

    private void startWithPersonalDefaults(String username, Map<String, Object> configurationWithDefaults) {
        this.personalDefaults.getOrDefault(username, Collections.emptyMap()).forEach((s, d) -> configurationWithDefaults.putIfAbsent((String)s, d.getValue()));
    }

    private Map<String, Object> startWithGlobalDefaults() {
        return this.globalDefaults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Default)e.getValue()).getValue()));
    }

    private void overlayPersonalDefaultsIfApplicable(Optional<String> username, Map<String, Object> defaults) {
        username.ifPresent(s -> this.personalDefaults.getOrDefault(s, Collections.emptyMap()).forEach((k, v) -> defaults.put((String)k, v.getValue())));
    }
}

