/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.configuration;

import org.neo4j.gds.configuration.Limit;
import org.neo4j.gds.utils.StringFormatting;

class BooleanLimit
extends Limit {
    private final boolean value;

    BooleanLimit(boolean value) {
        this.value = value;
    }

    @Override
    Object getValue() {
        return this.value;
    }

    @Override
    protected boolean isViolatedInternal(Object inputValue) {
        boolean b = (Boolean)inputValue;
        return b != this.value;
    }

    @Override
    String getValueAsString() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    String asErrorMessage(String key, Object value) {
        return StringFormatting.formatWithLocale((String)"Configuration parameter '%s' with value '%s' is in violation of it's set limit", (Object[])new Object[]{key, value});
    }
}

