/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.configuration;

import java.util.Locale;
import org.neo4j.gds.utils.StringFormatting;

abstract class Limit {
    Limit() {
    }

    abstract Object getValue();

    final boolean isViolated(Object inputValue) {
        this.assertTypeCompatible(inputValue);
        return this.isViolatedInternal(inputValue);
    }

    private void assertTypeCompatible(Object inputValue) {
        if (inputValue.getClass().isAssignableFrom(this.getValue().getClass())) {
            return;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Input value '%s' (%s) is not compatible with limit value '%s' (%s)", (Object[])new Object[]{inputValue, inputValue.getClass().getSimpleName().toLowerCase(Locale.ENGLISH), this.getValue(), this.getValue().getClass().getSimpleName().toLowerCase(Locale.ENGLISH)}));
    }

    protected abstract boolean isViolatedInternal(Object var1);

    @Deprecated
    abstract String getValueAsString();

    String asErrorMessage(String key, Object value) {
        return StringFormatting.formatWithLocale((String)"Configuration parameter '%s' with value '%s' exceeds it's limit of '%s'", (Object[])new Object[]{key, value, this.getValue()});
    }
}

