/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.configuration;

import java.util.Locale;
import org.neo4j.gds.configuration.BooleanLimit;
import org.neo4j.gds.configuration.DoubleLimit;
import org.neo4j.gds.configuration.Limit;
import org.neo4j.gds.configuration.LongLimit;
import org.neo4j.gds.utils.StringFormatting;

public final class LimitFactory {
    private LimitFactory() {
    }

    public static Limit create(Object value) {
        if (value instanceof Boolean) {
            return new BooleanLimit((Boolean)value);
        }
        if (value instanceof Double) {
            return new DoubleLimit((Double)value);
        }
        if (value instanceof Long) {
            return new LongLimit((Long)value);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Unable to create limit for input value '%s' (%s)", (Object[])new Object[]{value, value.getClass().getSimpleName().toLowerCase(Locale.ENGLISH)}));
    }
}

