/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.gds.configuration.Limit;
import org.neo4j.gds.configuration.LimitFactory;
import org.neo4j.gds.configuration.LimitViolation;

public class LimitsConfiguration {
    public static final LimitsConfiguration Instance = new LimitsConfiguration(new HashMap<String, Limit>(), new HashMap<String, Map<String, Limit>>());
    public static final LimitsConfiguration Empty = new LimitsConfiguration(Collections.emptyMap(), Collections.emptyMap());
    private final Map<String, Limit> globalLimits;
    private final Map<String, Map<String, Limit>> personalLimits;

    public LimitsConfiguration(Map<String, Limit> globalLimits, Map<String, Map<String, Limit>> personalLimits) {
        this.globalLimits = globalLimits;
        this.personalLimits = personalLimits;
    }

    public Set<LimitViolation> validate(Map<String, Object> configuration, String username) {
        HashSet<LimitViolation> limitViolations = new HashSet<LimitViolation>();
        for (Map.Entry<String, Object> inputParameter : configuration.entrySet()) {
            Limit limit;
            String key = inputParameter.getKey();
            Object value = inputParameter.getValue();
            if (this.personalLimits.getOrDefault(username, Collections.emptyMap()).containsKey(key) && (limit = this.personalLimits.get(username).get(key)).isViolated(value)) {
                limitViolations.add(new LimitViolation(limit.asErrorMessage(key, value)));
                continue;
            }
            if (!this.globalLimits.containsKey(key) || !(limit = this.globalLimits.get(key)).isViolated(value)) continue;
            LimitViolation limitViolation = new LimitViolation(limit.asErrorMessage(key, value));
            limitViolations.add(limitViolation);
        }
        return limitViolations;
    }

    public Map<String, Object> list(Optional<String> username, Optional<String> key) {
        Map<String, Object> limits = this.startWithGlobalLimits();
        this.overlayPersonalLimitsIfApplicable(username, limits);
        if (key.isEmpty()) {
            return limits;
        }
        if (!limits.containsKey(key.get())) {
            return Collections.emptyMap();
        }
        Object value = limits.get(key.get());
        return Map.of(key.get(), value);
    }

    public void set(String key, Object value, Optional<String> username) {
        Limit valueAsLimit = LimitFactory.create(value);
        if (username.isPresent()) {
            this.personalLimits.putIfAbsent(username.get(), new HashMap());
            this.personalLimits.get(username.get()).put(key, valueAsLimit);
        } else {
            this.globalLimits.put(key, valueAsLimit);
        }
    }

    private Map<String, Object> startWithGlobalLimits() {
        return this.globalLimits.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Limit)e.getValue()).getValue()));
    }

    private void overlayPersonalLimitsIfApplicable(Optional<String> username, Map<String, Object> defaults) {
        username.ifPresent(s -> this.personalLimits.getOrDefault(s, Collections.emptyMap()).forEach((k, v) -> defaults.put((String)k, v.getValue())));
    }
}

