/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.utils.StringFormatting;

public abstract class ElementProjection {
    public static final String PROJECT_ALL = "*";
    public static final String PROPERTIES_KEY = "properties";

    @Value.Default
    @Value.Parameter
    public PropertyMappings properties() {
        return PropertyMappings.of(new PropertyMapping[0]);
    }

    public abstract ElementProjection withAdditionalPropertyMappings(PropertyMappings var1);

    public abstract boolean projectAll();

    public final Map<String, Object> toObject() {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        this.writeToObject(value);
        value.put(PROPERTIES_KEY, this.properties().toObject(this.includeAggregation()));
        return value;
    }

    static <T extends ElementProjection> T create(Map<String, Object> config, Function<PropertyMappings, T> constructor) {
        Map properties = config.getOrDefault(PROPERTIES_KEY, Collections.emptyMap());
        PropertyMappings propertyMappings = PropertyMappings.fromObject(properties);
        return (T)((ElementProjection)constructor.apply(propertyMappings));
    }

    static String nonEmptyString(Map<String, Object> config, String key) {
        @Nullable Object value = config.get(key);
        if (!(value instanceof String) || ((String)value).isEmpty()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"'%s' is not a valid value for  the key '%s'", (Object[])new Object[]{value, key}));
        }
        return (String)value;
    }

    abstract void writeToObject(Map<String, Object> var1);

    abstract boolean includeAggregation();

    static final class InlinePropertiesBuilder {
        private final Supplier<PropertyMappings> getProperties;
        private final Consumer<PropertyMappings> setProperties;
        private PropertyMappings.Builder propertiesBuilder;

        InlinePropertiesBuilder(Supplier<PropertyMappings> getProperties, Consumer<PropertyMappings> setProperties) {
            this.getProperties = getProperties;
            this.setProperties = setProperties;
        }

        private void build() {
            if (this.propertiesBuilder != null) {
                if (this.getProperties.get() != null) {
                    throw new IllegalStateException("Cannot have both, a complete mapping from `properties` and other properties from `addProperty`. If you want to combine those, make sure to call `properties` first and then use `addProperty` and never set a new `properties`again.");
                }
                this.setProperties.accept(this.propertiesBuilder.build());
            }
        }

        private PropertyMappings.Builder propertiesBuilder() {
            if (this.propertiesBuilder == null) {
                this.propertiesBuilder = PropertyMappings.builder();
                PropertyMappings properties = this.getProperties.get();
                if (properties != null) {
                    this.propertiesBuilder.from(properties);
                    this.setProperties.accept(null);
                }
            }
            return this.propertiesBuilder;
        }
    }

    static interface InlineProperties<Self extends InlineProperties<Self>> {
        default public Self addProperty(PropertyMapping mapping) {
            this.inlineBuilder().propertiesBuilder().addMapping(mapping);
            return (Self)this;
        }

        default public Self addProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue) {
            return this.addProperty(propertyKey, neoPropertyKey, defaultValue, Aggregation.DEFAULT);
        }

        default public Self addProperty(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
            this.inlineBuilder().propertiesBuilder().addMapping(PropertyMapping.of(propertyKey, neoPropertyKey, defaultValue, aggregation));
            return (Self)this;
        }

        default public Self addProperties(PropertyMapping ... properties) {
            this.inlineBuilder().propertiesBuilder().addMappings(properties);
            return (Self)this;
        }

        default public Self addAllProperties(Iterable<? extends PropertyMapping> properties) {
            this.inlineBuilder().propertiesBuilder().addAllMappings(properties);
            return (Self)this;
        }

        default public void buildProperties() {
            this.inlineBuilder().build();
        }

        public InlinePropertiesBuilder inlineBuilder();
    }
}

