/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.PropertyMappings;

@Generated(from="NodeProjection", generator="Immutables")
public final class ImmutableNodeProjection
extends NodeProjection {
    private final String label;
    private final PropertyMappings properties;

    private ImmutableNodeProjection(String label, PropertyMappings properties) {
        this.label = Objects.requireNonNull(label, "label");
        this.properties = Objects.requireNonNull(properties, "properties");
    }

    private ImmutableNodeProjection(Builder builder) {
        this.label = builder.label;
        this.properties = builder.properties != null ? builder.properties : Objects.requireNonNull(super.properties(), "properties");
    }

    private ImmutableNodeProjection(ImmutableNodeProjection original, String label, PropertyMappings properties) {
        this.label = label;
        this.properties = properties;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public PropertyMappings properties() {
        return this.properties;
    }

    public final ImmutableNodeProjection withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeProjection(this, newValue, this.properties);
    }

    public final ImmutableNodeProjection withProperties(PropertyMappings value) {
        if (this.properties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "properties");
        return new ImmutableNodeProjection(this, this.label, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeProjection && this.equalTo(0, (ImmutableNodeProjection)another);
    }

    private boolean equalTo(int synthetic, ImmutableNodeProjection another) {
        return this.label.equals(another.label) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "NodeProjection{label=" + this.label + ", properties=" + this.properties + "}";
    }

    public static NodeProjection of(String label, PropertyMappings properties) {
        return new ImmutableNodeProjection(label, properties);
    }

    public static NodeProjection copyOf(NodeProjection instance) {
        if (instance instanceof ImmutableNodeProjection) {
            return (ImmutableNodeProjection)instance;
        }
        return new NodeProjection.Builder().from(instance).build();
    }

    @Generated(from="NodeProjection", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private long initBits = 1L;
        protected String label;
        protected PropertyMappings properties;

        public Builder() {
            if (!(this instanceof NodeProjection.Builder)) {
                throw new UnsupportedOperationException("Use: new NodeProjection.Builder()");
            }
        }

        public final NodeProjection.Builder from(ElementProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (NodeProjection.Builder)this;
        }

        public final NodeProjection.Builder from(NodeProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (NodeProjection.Builder)this;
        }

        private void from(Object object) {
            ElementProjection instance;
            if (object instanceof ElementProjection) {
                instance = (ElementProjection)object;
                this.properties(instance.properties());
            }
            if (object instanceof NodeProjection) {
                instance = (NodeProjection)object;
                this.label(((NodeProjection)instance).label());
            }
        }

        public final NodeProjection.Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (NodeProjection.Builder)this;
        }

        public final NodeProjection.Builder properties(PropertyMappings properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            return (NodeProjection.Builder)this;
        }

        public NodeProjection.Builder clear() {
            this.initBits = 1L;
            this.label = null;
            this.properties = null;
            return (NodeProjection.Builder)this;
        }

        public NodeProjection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeProjection(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("label");
            }
            return "Cannot build NodeProjection, some of required attributes are not set " + attributes;
        }
    }
}

