/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;

@Generated(from="NodeProjections", generator="Immutables")
public final class ImmutableNodeProjections
extends NodeProjections {
    private final Map<NodeLabel, NodeProjection> projections;
    private static final ImmutableNodeProjections INSTANCE = ImmutableNodeProjections.validate(new ImmutableNodeProjections());

    private ImmutableNodeProjections() {
        this.projections = Collections.emptyMap();
    }

    private ImmutableNodeProjections(Map<? extends NodeLabel, ? extends NodeProjection> projections) {
        this.projections = ImmutableNodeProjections.createUnmodifiableMap(true, false, projections);
    }

    private ImmutableNodeProjections(ImmutableNodeProjections original, Map<NodeLabel, NodeProjection> projections) {
        this.projections = projections;
    }

    @Override
    public Map<NodeLabel, NodeProjection> projections() {
        return this.projections;
    }

    public final ImmutableNodeProjections withProjections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
        if (this.projections == entries) {
            return this;
        }
        Map<NodeLabel, NodeProjection> newValue = ImmutableNodeProjections.createUnmodifiableMap(true, false, entries);
        return ImmutableNodeProjections.validate(new ImmutableNodeProjections(this, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeProjections && this.equalTo(0, (ImmutableNodeProjections)another);
    }

    private boolean equalTo(int synthetic, ImmutableNodeProjections another) {
        return this.projections.equals(another.projections);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.projections.hashCode();
        return h;
    }

    public String toString() {
        return "NodeProjections{projections=" + this.projections + "}";
    }

    public static NodeProjections of() {
        return INSTANCE;
    }

    public static NodeProjections of(Map<? extends NodeLabel, ? extends NodeProjection> projections) {
        return ImmutableNodeProjections.validate(new ImmutableNodeProjections(projections));
    }

    private static ImmutableNodeProjections validate(ImmutableNodeProjections instance) {
        instance.validatePropertyKeyMappings();
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static NodeProjections copyOf(NodeProjections instance) {
        if (instance instanceof ImmutableNodeProjections) {
            return (ImmutableNodeProjections)instance;
        }
        return ImmutableNodeProjections.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="NodeProjections", generator="Immutables")
    public static final class Builder {
        private Map<NodeLabel, NodeProjection> projections = null;

        private Builder() {
        }

        public final Builder from(NodeProjections instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProjections(instance.projections());
            return this;
        }

        public final Builder putProjection(NodeLabel key, NodeProjection value) {
            if (this.projections == null) {
                this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            }
            this.projections.put(Objects.requireNonNull(key, "projections key"), value == null ? Objects.requireNonNull(value, "projections value for key: " + key) : value);
            return this;
        }

        public final Builder putProjection(Map.Entry<? extends NodeLabel, ? extends NodeProjection> entry) {
            NodeProjection v;
            if (this.projections == null) {
                this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            }
            NodeLabel k = entry.getKey();
            this.projections.put(Objects.requireNonNull(k, "projections key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "projections value for key: " + k) : v);
            return this;
        }

        public final Builder projections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
            this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            return this.putAllProjections(entries);
        }

        public final Builder putAllProjections(Map<? extends NodeLabel, ? extends NodeProjection> entries) {
            if (this.projections == null) {
                this.projections = new LinkedHashMap<NodeLabel, NodeProjection>();
            }
            for (Map.Entry<? extends NodeLabel, ? extends NodeProjection> e : entries.entrySet()) {
                NodeProjection v;
                NodeLabel k = e.getKey();
                this.projections.put(Objects.requireNonNull(k, "projections key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "projections value for key: " + k) : v);
            }
            return this;
        }

        public Builder clear() {
            if (this.projections != null) {
                this.projections.clear();
            }
            return this;
        }

        public NodeProjections build() {
            return ImmutableNodeProjections.validate(new ImmutableNodeProjections(null, this.projections == null ? Collections.emptyMap() : ImmutableNodeProjections.createUnmodifiableMap(false, false, this.projections)));
        }
    }
}

