/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.core.Aggregation;

@Generated(from="PropertyMapping", generator="Immutables")
public final class ImmutablePropertyMapping
extends PropertyMapping {
    @Nullable
    private final String propertyKey;
    @Nullable
    private final String neoPropertyKey;
    private final DefaultValue defaultValue;
    private final Aggregation aggregation;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePropertyMapping(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        this.propertyKey = propertyKey;
        this.neoPropertyKey = neoPropertyKey;
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
        this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
        this.initShim = null;
    }

    private ImmutablePropertyMapping(Builder builder) {
        this.propertyKey = builder.propertyKey;
        if (builder.neoPropertyKeyIsSet()) {
            this.initShim.neoPropertyKey(builder.neoPropertyKey);
        }
        if (builder.defaultValue != null) {
            this.initShim.defaultValue(builder.defaultValue);
        }
        if (builder.aggregation != null) {
            this.initShim.aggregation(builder.aggregation);
        }
        this.neoPropertyKey = this.initShim.neoPropertyKey();
        this.defaultValue = this.initShim.defaultValue();
        this.aggregation = this.initShim.aggregation();
        this.initShim = null;
    }

    private ImmutablePropertyMapping(ImmutablePropertyMapping original, @Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        this.propertyKey = propertyKey;
        this.neoPropertyKey = neoPropertyKey;
        this.defaultValue = defaultValue;
        this.aggregation = aggregation;
        this.initShim = null;
    }

    @Override
    @Nullable
    public String propertyKey() {
        return this.propertyKey;
    }

    @Override
    @Nullable
    public String neoPropertyKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.neoPropertyKey() : this.neoPropertyKey;
    }

    @Override
    public DefaultValue defaultValue() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultValue() : this.defaultValue;
    }

    @Override
    public Aggregation aggregation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregation() : this.aggregation;
    }

    public final ImmutablePropertyMapping withPropertyKey(@Nullable String value) {
        if (Objects.equals(this.propertyKey, value)) {
            return this;
        }
        return ImmutablePropertyMapping.validate(new ImmutablePropertyMapping(this, value, this.neoPropertyKey, this.defaultValue, this.aggregation));
    }

    public final ImmutablePropertyMapping withNeoPropertyKey(@Nullable String value) {
        if (Objects.equals(this.neoPropertyKey, value)) {
            return this;
        }
        return ImmutablePropertyMapping.validate(new ImmutablePropertyMapping(this, this.propertyKey, value, this.defaultValue, this.aggregation));
    }

    public final ImmutablePropertyMapping withDefaultValue(DefaultValue value) {
        if (this.defaultValue == value) {
            return this;
        }
        DefaultValue newValue = Objects.requireNonNull(value, "defaultValue");
        return ImmutablePropertyMapping.validate(new ImmutablePropertyMapping(this, this.propertyKey, this.neoPropertyKey, newValue, this.aggregation));
    }

    public final ImmutablePropertyMapping withAggregation(Aggregation value) {
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation == newValue) {
            return this;
        }
        return ImmutablePropertyMapping.validate(new ImmutablePropertyMapping(this, this.propertyKey, this.neoPropertyKey, this.defaultValue, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertyMapping && this.equalTo(0, (ImmutablePropertyMapping)another);
    }

    private boolean equalTo(int synthetic, ImmutablePropertyMapping another) {
        return Objects.equals(this.propertyKey, another.propertyKey) && Objects.equals(this.neoPropertyKey, another.neoPropertyKey) && this.defaultValue.equals(another.defaultValue) && this.aggregation.equals((Object)another.aggregation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.propertyKey);
        h += (h << 5) + Objects.hashCode(this.neoPropertyKey);
        h += (h << 5) + this.defaultValue.hashCode();
        h += (h << 5) + this.aggregation.hashCode();
        return h;
    }

    public String toString() {
        return "PropertyMapping{propertyKey=" + this.propertyKey + ", neoPropertyKey=" + this.neoPropertyKey + ", defaultValue=" + this.defaultValue + ", aggregation=" + this.aggregation + "}";
    }

    public static PropertyMapping of(@Nullable String propertyKey, @Nullable String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
        return ImmutablePropertyMapping.validate(new ImmutablePropertyMapping(propertyKey, neoPropertyKey, defaultValue, aggregation));
    }

    private static ImmutablePropertyMapping validate(ImmutablePropertyMapping instance) {
        instance.validateProperties();
        return instance;
    }

    public static PropertyMapping copyOf(PropertyMapping instance) {
        if (instance instanceof ImmutablePropertyMapping) {
            return (ImmutablePropertyMapping)instance;
        }
        return ImmutablePropertyMapping.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PropertyMapping", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_NEO_PROPERTY_KEY = 1L;
        private long optBits;
        private String propertyKey;
        private String neoPropertyKey;
        private DefaultValue defaultValue;
        private Aggregation aggregation;

        private Builder() {
        }

        public final Builder from(PropertyMapping instance) {
            String neoPropertyKeyValue;
            Objects.requireNonNull(instance, "instance");
            @Nullable String propertyKeyValue = instance.propertyKey();
            if (propertyKeyValue != null) {
                this.propertyKey(propertyKeyValue);
            }
            if ((neoPropertyKeyValue = instance.neoPropertyKey()) != null) {
                this.neoPropertyKey(neoPropertyKeyValue);
            }
            this.defaultValue(instance.defaultValue());
            this.aggregation(instance.aggregation());
            return this;
        }

        public final Builder propertyKey(@Nullable String propertyKey) {
            this.propertyKey = propertyKey;
            return this;
        }

        public final Builder neoPropertyKey(@Nullable String neoPropertyKey) {
            this.neoPropertyKey = neoPropertyKey;
            this.optBits |= 1L;
            return this;
        }

        public final Builder defaultValue(DefaultValue defaultValue) {
            this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
            return this;
        }

        public final Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.propertyKey = null;
            this.neoPropertyKey = null;
            this.defaultValue = null;
            this.aggregation = null;
            return this;
        }

        public PropertyMapping build() {
            return ImmutablePropertyMapping.validate(new ImmutablePropertyMapping(this));
        }

        private boolean neoPropertyKeyIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="PropertyMapping", generator="Immutables")
    private final class InitShim {
        private byte neoPropertyKeyBuildStage = 0;
        private String neoPropertyKey;
        private byte defaultValueBuildStage = 0;
        private DefaultValue defaultValue;
        private byte aggregationBuildStage = 0;
        private Aggregation aggregation;

        private InitShim() {
        }

        String neoPropertyKey() {
            if (this.neoPropertyKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.neoPropertyKeyBuildStage == 0) {
                this.neoPropertyKeyBuildStage = (byte)-1;
                this.neoPropertyKey = ImmutablePropertyMapping.super.neoPropertyKey();
                this.neoPropertyKeyBuildStage = 1;
            }
            return this.neoPropertyKey;
        }

        void neoPropertyKey(String neoPropertyKey) {
            this.neoPropertyKey = neoPropertyKey;
            this.neoPropertyKeyBuildStage = 1;
        }

        DefaultValue defaultValue() {
            if (this.defaultValueBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultValueBuildStage == 0) {
                this.defaultValueBuildStage = (byte)-1;
                this.defaultValue = Objects.requireNonNull(ImmutablePropertyMapping.super.defaultValue(), "defaultValue");
                this.defaultValueBuildStage = 1;
            }
            return this.defaultValue;
        }

        void defaultValue(DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            this.defaultValueBuildStage = 1;
        }

        Aggregation aggregation() {
            if (this.aggregationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregationBuildStage == 0) {
                this.aggregationBuildStage = (byte)-1;
                this.aggregation = Objects.requireNonNull(ImmutablePropertyMapping.super.aggregation(), "aggregation");
                this.aggregationBuildStage = 1;
            }
            return this.aggregation;
        }

        void aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            this.aggregationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.neoPropertyKeyBuildStage == -1) {
                attributes.add("neoPropertyKey");
            }
            if (this.defaultValueBuildStage == -1) {
                attributes.add("defaultValue");
            }
            if (this.aggregationBuildStage == -1) {
                attributes.add("aggregation");
            }
            return "Cannot build PropertyMapping, attribute initializers form cycle " + attributes;
        }
    }
}

