/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;

@Generated(from="PropertyMappings", generator="Immutables")
public final class ImmutablePropertyMappings
extends PropertyMappings {
    private final List<PropertyMapping> mappings;
    private static final ImmutablePropertyMappings INSTANCE = ImmutablePropertyMappings.validate(new ImmutablePropertyMappings());

    private ImmutablePropertyMappings() {
        this.mappings = Collections.emptyList();
    }

    private ImmutablePropertyMappings(Iterable<? extends PropertyMapping> mappings) {
        this.mappings = ImmutablePropertyMappings.createUnmodifiableList(false, ImmutablePropertyMappings.createSafeList(mappings, true, false));
    }

    private ImmutablePropertyMappings(ImmutablePropertyMappings original, List<PropertyMapping> mappings) {
        this.mappings = mappings;
    }

    @Override
    public List<PropertyMapping> mappings() {
        return this.mappings;
    }

    public final ImmutablePropertyMappings withMappings(PropertyMapping ... elements) {
        List<PropertyMapping> newValue = ImmutablePropertyMappings.createUnmodifiableList(false, ImmutablePropertyMappings.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePropertyMappings.validate(new ImmutablePropertyMappings(this, newValue));
    }

    public final ImmutablePropertyMappings withMappings(Iterable<? extends PropertyMapping> elements) {
        if (this.mappings == elements) {
            return this;
        }
        List<PropertyMapping> newValue = ImmutablePropertyMappings.createUnmodifiableList(false, ImmutablePropertyMappings.createSafeList(elements, true, false));
        return ImmutablePropertyMappings.validate(new ImmutablePropertyMappings(this, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePropertyMappings && this.equalTo(0, (ImmutablePropertyMappings)another);
    }

    private boolean equalTo(int synthetic, ImmutablePropertyMappings another) {
        return this.mappings.equals(another.mappings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mappings.hashCode();
        return h;
    }

    public String toString() {
        return "PropertyMappings{mappings=" + this.mappings + "}";
    }

    public static PropertyMappings of() {
        return INSTANCE;
    }

    public static PropertyMappings of(List<PropertyMapping> mappings) {
        return ImmutablePropertyMappings.of(mappings);
    }

    public static PropertyMappings of(Iterable<? extends PropertyMapping> mappings) {
        return ImmutablePropertyMappings.validate(new ImmutablePropertyMappings(mappings));
    }

    private static ImmutablePropertyMappings validate(ImmutablePropertyMappings instance) {
        instance.checkForAggregationMixing();
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static PropertyMappings copyOf(PropertyMappings instance) {
        if (instance instanceof ImmutablePropertyMappings) {
            return (ImmutablePropertyMappings)instance;
        }
        return new PropertyMappings.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PropertyMappings", generator="Immutables")
    public static class Builder {
        protected List<PropertyMapping> mappings = null;

        public Builder() {
            if (!(this instanceof PropertyMappings.Builder)) {
                throw new UnsupportedOperationException("Use: new PropertyMappings.Builder()");
            }
        }

        public final PropertyMappings.Builder from(PropertyMappings instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMappings(instance.mappings());
            return (PropertyMappings.Builder)this;
        }

        public final PropertyMappings.Builder addMapping(PropertyMapping element) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<PropertyMapping>();
            }
            this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            return (PropertyMappings.Builder)this;
        }

        public final PropertyMappings.Builder addMappings(PropertyMapping ... elements) {
            if (this.mappings == null) {
                this.mappings = new ArrayList<PropertyMapping>();
            }
            for (PropertyMapping element : elements) {
                this.mappings.add(Objects.requireNonNull(element, "mappings element"));
            }
            return (PropertyMappings.Builder)this;
        }

        public final PropertyMappings.Builder mappings(Iterable<? extends PropertyMapping> elements) {
            this.mappings = new ArrayList<PropertyMapping>();
            return this.addAllMappings(elements);
        }

        public final PropertyMappings.Builder addAllMappings(Iterable<? extends PropertyMapping> elements) {
            Objects.requireNonNull(elements, "mappings element");
            if (this.mappings == null) {
                this.mappings = new ArrayList<PropertyMapping>();
            }
            for (PropertyMapping propertyMapping : elements) {
                this.mappings.add(Objects.requireNonNull(propertyMapping, "mappings element"));
            }
            return (PropertyMappings.Builder)this;
        }

        public PropertyMappings.Builder clear() {
            if (this.mappings != null) {
                this.mappings.clear();
            }
            return (PropertyMappings.Builder)this;
        }

        public PropertyMappings build() {
            return ImmutablePropertyMappings.validate(new ImmutablePropertyMappings(null, this.mappings == null ? Collections.emptyList() : ImmutablePropertyMappings.createUnmodifiableList(true, this.mappings)));
        }
    }
}

