/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.core.Aggregation;

@Generated(from="RelationshipProjection", generator="Immutables")
public final class ImmutableRelationshipProjection
extends RelationshipProjection {
    private final String type;
    private final Orientation orientation;
    private final Aggregation aggregation;
    private final boolean indexInverse;
    private final PropertyMappings properties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRelationshipProjection(String type, Orientation orientation, Aggregation aggregation, boolean indexInverse) {
        this.type = Objects.requireNonNull(type, "type");
        this.initShim.orientation(Objects.requireNonNull(orientation, "orientation"));
        this.initShim.aggregation(Objects.requireNonNull(aggregation, "aggregation"));
        this.initShim.indexInverse(indexInverse);
        this.orientation = this.initShim.orientation();
        this.aggregation = this.initShim.aggregation();
        this.indexInverse = this.initShim.indexInverse();
        this.properties = this.initShim.properties();
        this.initShim = null;
    }

    private ImmutableRelationshipProjection(Builder builder) {
        this.type = builder.type;
        if (builder.orientation != null) {
            this.initShim.orientation(builder.orientation);
        }
        if (builder.aggregation != null) {
            this.initShim.aggregation(builder.aggregation);
        }
        if (builder.indexInverseIsSet()) {
            this.initShim.indexInverse(builder.indexInverse);
        }
        if (builder.properties != null) {
            this.initShim.properties(builder.properties);
        }
        this.orientation = this.initShim.orientation();
        this.aggregation = this.initShim.aggregation();
        this.indexInverse = this.initShim.indexInverse();
        this.properties = this.initShim.properties();
        this.initShim = null;
    }

    private ImmutableRelationshipProjection(String type, Orientation orientation, Aggregation aggregation, boolean indexInverse, PropertyMappings properties) {
        this.type = type;
        this.orientation = orientation;
        this.aggregation = aggregation;
        this.indexInverse = indexInverse;
        this.properties = properties;
        this.initShim = null;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Orientation orientation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.orientation() : this.orientation;
    }

    @Override
    public Aggregation aggregation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.aggregation() : this.aggregation;
    }

    @Override
    public boolean indexInverse() {
        InitShim shim = this.initShim;
        return shim != null ? shim.indexInverse() : this.indexInverse;
    }

    @Override
    public PropertyMappings properties() {
        InitShim shim = this.initShim;
        return shim != null ? shim.properties() : this.properties;
    }

    public final ImmutableRelationshipProjection withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(newValue, this.orientation, this.aggregation, this.indexInverse, this.properties));
    }

    public final ImmutableRelationshipProjection withOrientation(Orientation value) {
        Orientation newValue = Objects.requireNonNull(value, "orientation");
        if (this.orientation == newValue) {
            return this;
        }
        return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(this.type, newValue, this.aggregation, this.indexInverse, this.properties));
    }

    public final ImmutableRelationshipProjection withAggregation(Aggregation value) {
        Aggregation newValue = Objects.requireNonNull(value, "aggregation");
        if (this.aggregation == newValue) {
            return this;
        }
        return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(this.type, this.orientation, newValue, this.indexInverse, this.properties));
    }

    public final ImmutableRelationshipProjection withIndexInverse(boolean value) {
        if (this.indexInverse == value) {
            return this;
        }
        return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(this.type, this.orientation, this.aggregation, value, this.properties));
    }

    public final ImmutableRelationshipProjection withProperties(PropertyMappings value) {
        if (this.properties == value) {
            return this;
        }
        PropertyMappings newValue = Objects.requireNonNull(value, "properties");
        return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(this.type, this.orientation, this.aggregation, this.indexInverse, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelationshipProjection && this.equalTo(0, (ImmutableRelationshipProjection)another);
    }

    private boolean equalTo(int synthetic, ImmutableRelationshipProjection another) {
        return this.type.equals(another.type) && this.orientation.equals((Object)another.orientation) && this.aggregation.equals((Object)another.aggregation) && this.indexInverse == another.indexInverse && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.orientation.hashCode();
        h += (h << 5) + this.aggregation.hashCode();
        h += (h << 5) + Boolean.hashCode(this.indexInverse);
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return "RelationshipProjection{type=" + this.type + ", orientation=" + this.orientation + ", aggregation=" + this.aggregation + ", indexInverse=" + this.indexInverse + ", properties=" + this.properties + "}";
    }

    public static RelationshipProjection of(String type, Orientation orientation, Aggregation aggregation, boolean indexInverse) {
        return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(type, orientation, aggregation, indexInverse));
    }

    private static ImmutableRelationshipProjection validate(ImmutableRelationshipProjection instance) {
        instance.check();
        return instance;
    }

    public static RelationshipProjection copyOf(RelationshipProjection instance) {
        if (instance instanceof ImmutableRelationshipProjection) {
            return (ImmutableRelationshipProjection)instance;
        }
        return new RelationshipProjection.Builder().from(instance).build();
    }

    @Generated(from="RelationshipProjection", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long OPT_BIT_INDEX_INVERSE = 1L;
        private long initBits = 1L;
        private long optBits;
        protected String type;
        protected Orientation orientation;
        protected Aggregation aggregation;
        protected boolean indexInverse;
        protected PropertyMappings properties;

        public Builder() {
            if (!(this instanceof RelationshipProjection.Builder)) {
                throw new UnsupportedOperationException("Use: new RelationshipProjection.Builder()");
            }
        }

        public final RelationshipProjection.Builder from(RelationshipProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (RelationshipProjection.Builder)this;
        }

        public final RelationshipProjection.Builder from(ElementProjection instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (RelationshipProjection.Builder)this;
        }

        private void from(Object object) {
            ElementProjection instance;
            if (object instanceof RelationshipProjection) {
                instance = (RelationshipProjection)object;
                this.orientation(((RelationshipProjection)instance).orientation());
                this.aggregation(((RelationshipProjection)instance).aggregation());
                this.type(((RelationshipProjection)instance).type());
                this.indexInverse(((RelationshipProjection)instance).indexInverse());
            }
            if (object instanceof ElementProjection) {
                instance = (ElementProjection)object;
                this.properties(instance.properties());
            }
        }

        public final RelationshipProjection.Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (RelationshipProjection.Builder)this;
        }

        public final RelationshipProjection.Builder orientation(Orientation orientation) {
            this.orientation = Objects.requireNonNull(orientation, "orientation");
            return (RelationshipProjection.Builder)this;
        }

        public final RelationshipProjection.Builder aggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation");
            return (RelationshipProjection.Builder)this;
        }

        public final RelationshipProjection.Builder indexInverse(boolean indexInverse) {
            this.indexInverse = indexInverse;
            this.optBits |= 1L;
            return (RelationshipProjection.Builder)this;
        }

        public final RelationshipProjection.Builder properties(PropertyMappings properties) {
            this.properties = Objects.requireNonNull(properties, "properties");
            return (RelationshipProjection.Builder)this;
        }

        public RelationshipProjection.Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.type = null;
            this.orientation = null;
            this.aggregation = null;
            this.indexInverse = false;
            this.properties = null;
            return (RelationshipProjection.Builder)this;
        }

        public RelationshipProjection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableRelationshipProjection.validate(new ImmutableRelationshipProjection(this));
        }

        private boolean indexInverseIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build RelationshipProjection, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="RelationshipProjection", generator="Immutables")
    private final class InitShim {
        private byte orientationBuildStage = 0;
        private Orientation orientation;
        private byte aggregationBuildStage = 0;
        private Aggregation aggregation;
        private byte indexInverseBuildStage = 0;
        private boolean indexInverse;
        private byte propertiesBuildStage = 0;
        private PropertyMappings properties;

        private InitShim() {
        }

        Orientation orientation() {
            if (this.orientationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orientationBuildStage == 0) {
                this.orientationBuildStage = (byte)-1;
                this.orientation = Objects.requireNonNull(ImmutableRelationshipProjection.super.orientation(), "orientation");
                this.orientationBuildStage = 1;
            }
            return this.orientation;
        }

        void orientation(Orientation orientation) {
            this.orientation = orientation;
            this.orientationBuildStage = 1;
        }

        Aggregation aggregation() {
            if (this.aggregationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aggregationBuildStage == 0) {
                this.aggregationBuildStage = (byte)-1;
                this.aggregation = Objects.requireNonNull(ImmutableRelationshipProjection.super.aggregation(), "aggregation");
                this.aggregationBuildStage = 1;
            }
            return this.aggregation;
        }

        void aggregation(Aggregation aggregation) {
            this.aggregation = aggregation;
            this.aggregationBuildStage = 1;
        }

        boolean indexInverse() {
            if (this.indexInverseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.indexInverseBuildStage == 0) {
                this.indexInverseBuildStage = (byte)-1;
                this.indexInverse = ImmutableRelationshipProjection.super.indexInverse();
                this.indexInverseBuildStage = 1;
            }
            return this.indexInverse;
        }

        void indexInverse(boolean indexInverse) {
            this.indexInverse = indexInverse;
            this.indexInverseBuildStage = 1;
        }

        PropertyMappings properties() {
            if (this.propertiesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesBuildStage == 0) {
                this.propertiesBuildStage = (byte)-1;
                this.properties = Objects.requireNonNull(ImmutableRelationshipProjection.super.properties(), "properties");
                this.propertiesBuildStage = 1;
            }
            return this.properties;
        }

        void properties(PropertyMappings properties) {
            this.properties = properties;
            this.propertiesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orientationBuildStage == -1) {
                attributes.add("orientation");
            }
            if (this.aggregationBuildStage == -1) {
                attributes.add("aggregation");
            }
            if (this.indexInverseBuildStage == -1) {
                attributes.add("indexInverse");
            }
            if (this.propertiesBuildStage == -1) {
                attributes.add("properties");
            }
            return "Cannot build RelationshipProjection, attribute initializers form cycle " + attributes;
        }
    }
}

