/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.ElementIdentifier;

public class NodeLabel
extends ElementIdentifier {
    public static final NodeLabel ALL_NODES = NodeLabel.of("__ALL__");

    public NodeLabel(String name) {
        super(name, "Node label");
    }

    @Override
    public ElementIdentifier projectAll() {
        return ALL_NODES;
    }

    public static NodeLabel of(@NotNull String name) {
        return new NodeLabel(name);
    }

    public static Collection<NodeLabel> listOf(String ... nodeLabels) {
        return Arrays.stream(nodeLabels).map(NodeLabel::of).collect(Collectors.toList());
    }
}

