/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.ImmutableNodeProjection;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
public abstract class NodeProjection
extends ElementProjection {
    private static final NodeProjection ALL = NodeProjection.fromString("*");
    public static final String LABEL_KEY = "label";

    public abstract String label();

    @Override
    @Value.Default
    public PropertyMappings properties() {
        return super.properties();
    }

    @Override
    public boolean projectAll() {
        return this.label().equals("*");
    }

    public static NodeProjection of(String label) {
        return ImmutableNodeProjection.of(label, PropertyMappings.of(new PropertyMapping[0]));
    }

    public static NodeProjection all() {
        return ALL;
    }

    public static NodeProjection fromObject(Object object, NodeLabel nodeLabel) {
        if (object instanceof String) {
            return NodeProjection.fromString((String)object);
        }
        if (object instanceof Map) {
            TreeMap<String, Object> caseInsensitiveMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveMap.putAll((Map)object);
            return NodeProjection.fromMap(caseInsensitiveMap, nodeLabel);
        }
        if (object instanceof NodeProjection) {
            return (NodeProjection)object;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct a node filter out of a %s", (Object[])new Object[]{object.getClass().getName()}));
    }

    public static NodeProjection fromString(@Nullable String label) {
        return NodeProjection.builder().label(label).build();
    }

    public static NodeProjection fromMap(Map<String, Object> map, NodeLabel nodeLabel) {
        NodeProjection.validateConfigKeys(map);
        String label = String.valueOf(map.getOrDefault(LABEL_KEY, nodeLabel.name));
        return NodeProjection.create(map, properties -> ImmutableNodeProjection.of(label, properties));
    }

    @Override
    boolean includeAggregation() {
        return false;
    }

    @Override
    void writeToObject(Map<String, Object> value) {
        value.put(LABEL_KEY, this.label());
    }

    @Override
    public NodeProjection withAdditionalPropertyMappings(PropertyMappings mappings) {
        PropertyMappings newMappings = this.properties().mergeWith(mappings);
        if (newMappings == this.properties()) {
            return this;
        }
        return ((ImmutableNodeProjection)this).withProperties(newMappings);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void validateConfigKeys(Map<String, Object> map) {
        ConfigKeyValidation.requireOnlyKeysFrom(List.of(LABEL_KEY, "properties"), map.keySet());
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends ImmutableNodeProjection.Builder
    implements ElementProjection.InlineProperties<Builder> {
        private ElementProjection.InlinePropertiesBuilder propertiesBuilder;

        Builder() {
        }

        @Override
        public NodeProjection build() {
            this.buildProperties();
            return super.build();
        }

        @Override
        public ElementProjection.InlinePropertiesBuilder inlineBuilder() {
            if (this.propertiesBuilder == null) {
                this.propertiesBuilder = new ElementProjection.InlinePropertiesBuilder(() -> this.properties, newProperties -> {
                    this.properties = newProperties;
                });
            }
            return this.propertiesBuilder;
        }
    }
}

