/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.AbstractProjections;
import org.neo4j.gds.ImmutableNodeProjections;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Value.Immutable(singleton=true)
public abstract class NodeProjections
extends AbstractProjections<NodeLabel, NodeProjection> {
    public static final NodeProjections ALL = NodeProjections.create(Collections.singletonMap(NodeLabel.ALL_NODES, NodeProjection.all()));

    @Override
    public abstract Map<NodeLabel, NodeProjection> projections();

    public static NodeProjections fromObject(Object object) {
        if (object == null) {
            return NodeProjections.fromMap(Collections.emptyMap());
        }
        if (object instanceof NodeProjections) {
            return (NodeProjections)object;
        }
        if (object instanceof String) {
            return NodeProjections.fromString((String)object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return NodeProjections.fromMap(map);
        }
        if (object instanceof Iterable) {
            Iterable list = (Iterable)object;
            return NodeProjections.fromList(list);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct a node projection out of a %s", (Object[])new Object[]{object.getClass().getName()}));
    }

    public static NodeProjections fromString(@Nullable String labelString) {
        NodeProjections.validateIdentifierName(labelString);
        if (StringFormatting.isEmpty((String)labelString)) {
            NodeProjections.create(Collections.emptyMap());
        }
        if (labelString.equals("*")) {
            return NodeProjections.create(Collections.singletonMap(NodeLabel.ALL_NODES, NodeProjection.all()));
        }
        NodeLabel nodeLabel = new NodeLabel(labelString);
        NodeProjection projection = NodeProjection.fromString(labelString);
        return NodeProjections.create(Collections.singletonMap(nodeLabel, projection));
    }

    private static NodeProjections fromMap(Map<String, ?> map) {
        LinkedHashMap<NodeLabel, NodeProjection> projections = new LinkedHashMap<NodeLabel, NodeProjection>();
        map.forEach((name, spec) -> {
            NodeLabel nodeLabel = new NodeLabel((String)name);
            NodeProjection projection = NodeProjection.fromObject(spec, nodeLabel);
            if (projections.put(nodeLabel, projection) != null) {
                throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate key: %s", (Object[])new Object[]{name}));
            }
        });
        return NodeProjections.create(projections);
    }

    private static NodeProjections fromList(Iterable<?> items) {
        LinkedHashMap<NodeLabel, NodeProjection> projections = new LinkedHashMap<NodeLabel, NodeProjection>();
        for (Object item : items) {
            NodeProjections nodeProjections = NodeProjections.fromObject(item);
            projections.putAll(nodeProjections.projections());
        }
        return NodeProjections.create(projections);
    }

    public static NodeProjections create(Map<NodeLabel, NodeProjection> projections) {
        if (projections.isEmpty()) {
            throw new IllegalArgumentException("An empty node projection was given; at least one node label must be projected.");
        }
        return ImmutableNodeProjections.of(Collections.unmodifiableMap(projections));
    }

    public static NodeProjections single(NodeLabel label, NodeProjection projection) {
        return ImmutableNodeProjections.of(Map.of(label, projection));
    }

    public static NodeProjections all() {
        return ALL;
    }

    public NodeProjections addPropertyMappings(PropertyMappings mappings) {
        if (!mappings.hasMappings()) {
            return ImmutableNodeProjections.copyOf(this);
        }
        Map<NodeLabel, NodeProjection> newProjections = this.projections().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((NodeProjection)e.getValue()).withAdditionalPropertyMappings(mappings)));
        if (newProjections.isEmpty()) {
            newProjections.put(NodeLabel.ALL_NODES, NodeProjection.all().withAdditionalPropertyMappings(mappings));
        }
        return NodeProjections.create(newProjections);
    }

    public String labelProjection() {
        if (this.isEmpty()) {
            return "";
        }
        return this.projections().values().stream().map(NodeProjection::label).collect(Collectors.joining(", "));
    }

    public boolean isEmpty() {
        return this == ImmutableNodeProjections.of();
    }

    public Map<String, Object> toObject() {
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        this.projections().forEach((identifier, projection) -> value.put(identifier.name, projection.toObject()));
        return value;
    }

    public static Map<String, Object> toObject(NodeProjections nodeProjections) {
        return nodeProjections.toObject();
    }

    private static void validateIdentifierName(String identifier) {
        if (identifier.equals(NodeLabel.ALL_NODES.name())) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"%s is a reserved node label and may not be used", (Object[])new Object[]{NodeLabel.ALL_NODES.name()}));
        }
    }

    @Value.Check
    public void validatePropertyKeyMappings() {
        HashMap seenMappings = new HashMap();
        this.projections().values().stream().flatMap(nodeProjection -> nodeProjection.properties().stream()).forEach(propertyMapping -> {
            String propertyKey = propertyMapping.propertyKey();
            if (seenMappings.containsKey(propertyKey)) {
                PropertyMapping seenMapping = (PropertyMapping)seenMappings.get(propertyKey);
                if (!Objects.equals(seenMapping.neoPropertyKey(), propertyMapping.neoPropertyKey())) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Specifying multiple neoPropertyKeys for the same property is not allowed, found propertyKey: `%s` with conflicting neoPropertyKeys: `%s`, `%s`.", (Object[])new Object[]{propertyKey, propertyMapping.neoPropertyKey(), seenMapping.neoPropertyKey()}));
                }
                if (!Objects.equals(seenMapping.defaultValue(), propertyMapping.defaultValue())) {
                    throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Specifying different default values for the same property with identical neoPropertyKey is not allowed, found propertyKey: `%s` with conflicting default values: `%s`, `%s`.", (Object[])new Object[]{propertyKey, propertyMapping.defaultValue().getObject(), seenMapping.defaultValue().getObject()}));
                }
            }
            seenMappings.put(propertyKey, propertyMapping);
        });
    }
}

