/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum Orientation {
    NATURAL{

        @Override
        public Orientation inverse() {
            return REVERSE;
        }
    }
    ,
    REVERSE{

        @Override
        public Orientation inverse() {
            return NATURAL;
        }
    }
    ,
    UNDIRECTED{

        @Override
        public Orientation inverse() {
            return UNDIRECTED;
        }
    };

    private static final List<String> VALUES;

    public abstract Orientation inverse();

    public static Orientation parse(Object input) {
        if (input instanceof String) {
            String inputString = ((String)input).toUpperCase(Locale.ENGLISH);
            if (VALUES.contains(inputString)) {
                return Orientation.valueOf(inputString);
            }
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Orientation `%s` is not supported. Must be one of: %s.", inputString, VALUES));
        }
        if (input instanceof Orientation) {
            return (Orientation)((Object)input);
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Expected Orientation or String. Got %s.", input.getClass().getSimpleName()));
    }

    public static String toString(Orientation orientation) {
        return orientation.toString();
    }

    static {
        VALUES = Arrays.stream(Orientation.values()).map(Enum::name).collect(Collectors.toList());
    }
}

