/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.neo4j.gds.ImmutablePropertyMappings;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Value.Immutable(singleton=true)
public abstract class PropertyMappings
implements Iterable<PropertyMapping> {
    public abstract List<PropertyMapping> mappings();

    public static PropertyMappings of(PropertyMapping ... mappings) {
        if (mappings == null) {
            return ImmutablePropertyMappings.of();
        }
        return ImmutablePropertyMappings.of(Arrays.asList(mappings));
    }

    public static PropertyMappings fromObject(Object propertyMappingInput) {
        return PropertyMappings.fromObject(propertyMappingInput, Aggregation.DEFAULT);
    }

    public static PropertyMappings fromObject(Object propertyMappingInput, Aggregation defaultAggregation) {
        if (propertyMappingInput instanceof ImmutablePropertyMappings) {
            ImmutablePropertyMappings properties = (ImmutablePropertyMappings)propertyMappingInput;
            return ImmutablePropertyMappings.builder().from(properties).withDefaultAggregation(defaultAggregation).build();
        }
        if (propertyMappingInput instanceof String) {
            String propertyMapping = (String)propertyMappingInput;
            return PropertyMappings.fromObject(Collections.singletonMap(propertyMapping, propertyMapping), defaultAggregation);
        }
        if (propertyMappingInput instanceof List) {
            Builder builder = PropertyMappings.builder().withDefaultAggregation(defaultAggregation);
            for (Object mapping : (List)propertyMappingInput) {
                List<PropertyMapping> propertyMappings = PropertyMappings.fromObject(mapping, defaultAggregation).mappings();
                for (PropertyMapping propertyMapping : propertyMappings) {
                    if (builder.mappings != null && builder.mappings.contains(propertyMapping)) {
                        throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate property key `%s`", (Object[])new Object[]{propertyMapping.propertyKey()}));
                    }
                    builder.addMapping(propertyMapping);
                }
            }
            return builder.build();
        }
        if (propertyMappingInput instanceof Map) {
            Builder builder = PropertyMappings.builder().withDefaultAggregation(defaultAggregation);
            ((Map)propertyMappingInput).forEach((? super K key, ? super V spec) -> {
                PropertyMapping propertyMapping = PropertyMapping.fromObject(key, spec);
                builder.addMapping(propertyMapping);
            });
            return builder.build();
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Expected String or Map for property mappings. Got %s.", (Object[])new Object[]{propertyMappingInput.getClass().getSimpleName()}));
    }

    public static Map<String, Object> toObject(PropertyMappings propertyMappings) {
        return propertyMappings.toObject(true);
    }

    public Set<String> propertyKeys() {
        return this.stream().map(PropertyMapping::propertyKey).collect(Collectors.toSet());
    }

    public Stream<PropertyMapping> stream() {
        return this.mappings().stream();
    }

    @Override
    public Iterator<PropertyMapping> iterator() {
        return this.mappings().iterator();
    }

    public boolean hasMappings() {
        return !this.mappings().isEmpty();
    }

    public int numberOfMappings() {
        return this.mappings().size();
    }

    public boolean isEmpty() {
        return this.mappings().isEmpty();
    }

    public Map<String, Object> toObject(boolean includeAggregation) {
        return this.stream().map(mapping -> mapping.toObject(includeAggregation)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(StringFormatting.formatWithLocale((String)"Duplicate key %s", (Object[])new Object[]{u}));
        }, LinkedHashMap::new));
    }

    public PropertyMappings mergeWith(PropertyMappings other) {
        if (!this.hasMappings()) {
            return other;
        }
        if (!other.hasMappings()) {
            return ImmutablePropertyMappings.copyOf(this);
        }
        Builder builder = PropertyMappings.builder();
        builder.addMappings(Stream.concat(this.stream(), other.stream()).distinct());
        return builder.build();
    }

    @Value.Check
    void checkForAggregationMixing() {
        long noneStrategyCount = this.stream().filter(d -> d.aggregation() == Aggregation.NONE).count();
        if (noneStrategyCount > 0L && noneStrategyCount < (long)this.numberOfMappings()) {
            throw new IllegalArgumentException("Conflicting relationship property aggregations, it is not allowed to mix `NONE` with aggregations.");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends ImmutablePropertyMappings.Builder {
        private Aggregation aggregation = Aggregation.DEFAULT;

        Builder() {
        }

        void addMappings(Stream<? extends PropertyMapping> propertyMappings) {
            Objects.requireNonNull(propertyMappings, "propertyMappings must not be null.");
            propertyMappings.forEach(this::addMapping);
        }

        public Builder withDefaultAggregation(Aggregation aggregation) {
            this.aggregation = Objects.requireNonNull(aggregation, "aggregation must not be empty");
            return this;
        }

        @Override
        public PropertyMappings build() {
            if (this.aggregation != Aggregation.DEFAULT && this.mappings != null) {
                ListIterator<PropertyMapping> iter = this.mappings.listIterator();
                while (iter.hasNext()) {
                    PropertyMapping mapping = ((PropertyMapping)iter.next()).setNonDefaultAggregation(this.aggregation);
                    iter.set(mapping);
                }
            }
            return super.build();
        }
    }
}

