/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.ImmutableRelationshipProjection;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
public abstract class RelationshipProjection
extends ElementProjection {
    public static final RelationshipProjection ALL = RelationshipProjection.of("*", Orientation.NATURAL);
    public static final RelationshipProjection ALL_UNDIRECTED = RelationshipProjection.of("*", Orientation.UNDIRECTED);
    public static final String TYPE_KEY = "type";
    public static final String ORIENTATION_KEY = "orientation";
    public static final String AGGREGATION_KEY = "aggregation";
    public static final String INDEX_INVERSE_KEY = "indexInverse";

    public abstract String type();

    @Value.Default
    public Orientation orientation() {
        return Orientation.NATURAL;
    }

    @Value.Default
    public Aggregation aggregation() {
        return Aggregation.DEFAULT;
    }

    @Value.Default
    public boolean indexInverse() {
        return false;
    }

    @Override
    @Value.Default
    @Value.Parameter(value=false)
    public PropertyMappings properties() {
        return super.properties();
    }

    @Value.Check
    protected void check() {
        if (this.orientation() == Orientation.UNDIRECTED && this.indexInverse()) {
            throw new IllegalArgumentException("Relationship projection `" + this.type() + "` cannot be UNDIRECTED and inverse indexed. Indexing the inverse orientation is only allowed for NATURAL and REVERSE.");
        }
    }

    public void checkAggregation() {
        this.check();
        if (this.properties().isEmpty()) {
            switch (this.aggregation()) {
                case COUNT: 
                case SUM: 
                case MIN: 
                case MAX: {
                    throw new IllegalArgumentException("Setting a global `" + this.aggregation() + "` aggregation requires at least one property mapping.");
                }
            }
        }
    }

    @Override
    public boolean projectAll() {
        return this.type().equals("*");
    }

    public static RelationshipProjection fromMap(Map<String, Object> map, RelationshipType relationshipType) {
        Builder builder = RelationshipProjection.builder();
        String type = String.valueOf(map.getOrDefault(TYPE_KEY, relationshipType.name));
        RelationshipProjection.validateConfigKeys(map);
        builder.type(type);
        if (map.containsKey(ORIENTATION_KEY)) {
            builder.orientation(Orientation.parse(RelationshipProjection.nonEmptyString(map, ORIENTATION_KEY)));
        }
        if (map.containsKey(INDEX_INVERSE_KEY)) {
            boolean indexInverse = (Boolean)map.get(INDEX_INVERSE_KEY);
            builder.indexInverse(indexInverse);
        }
        if (map.containsKey(AGGREGATION_KEY)) {
            Aggregation aggregation = Aggregation.parse(RelationshipProjection.nonEmptyString(map, AGGREGATION_KEY));
            builder.aggregation(aggregation);
            return RelationshipProjection.create(map, aggregation, properties -> builder.properties((PropertyMappings)properties).build());
        }
        return RelationshipProjection.create(map, properties -> builder.properties((PropertyMappings)properties).build());
    }

    public static RelationshipProjection fromString(@Nullable String type) {
        return RelationshipProjection.builder().type(type).build();
    }

    public static RelationshipProjection fromObject(Object object, RelationshipType relationshipType) {
        if (object == null) {
            return ALL;
        }
        if (object instanceof String) {
            return RelationshipProjection.fromString((String)object);
        }
        if (object instanceof Map) {
            TreeMap<String, Object> caseInsensitiveMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            caseInsensitiveMap.putAll((Map)object);
            return RelationshipProjection.fromMap(caseInsensitiveMap, relationshipType);
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Cannot construct a relationship filter out of a %s", (Object[])new Object[]{object.getClass().getName()}));
    }

    public static RelationshipProjection of(String type, Orientation orientation) {
        return RelationshipProjection.builder().type(type).orientation(orientation).build();
    }

    public static RelationshipProjection of(String type, Aggregation aggregation) {
        return RelationshipProjection.builder().type(type).aggregation(aggregation).build();
    }

    public static RelationshipProjection of(String type, Orientation orientation, Aggregation aggregation) {
        return RelationshipProjection.builder().type(type).aggregation(aggregation).orientation(orientation).build();
    }

    public boolean isMultiGraph() {
        boolean somePropertyIsNotAggregated = this.properties().mappings().stream().anyMatch(m -> Aggregation.equivalentToNone(m.aggregation()));
        return Aggregation.equivalentToNone(this.aggregation()) && (this.properties().isEmpty() || somePropertyIsNotAggregated);
    }

    @Override
    boolean includeAggregation() {
        return true;
    }

    @Override
    void writeToObject(Map<String, Object> value) {
        value.put(TYPE_KEY, this.type());
        value.put(ORIENTATION_KEY, this.orientation().name());
        value.put(AGGREGATION_KEY, this.aggregation().name());
        value.put(INDEX_INVERSE_KEY, this.indexInverse());
    }

    @Override
    public RelationshipProjection withAdditionalPropertyMappings(PropertyMappings mappings) {
        PropertyMappings withSameAggregation = PropertyMappings.builder().from(mappings).withDefaultAggregation(this.aggregation()).build();
        PropertyMappings newMappings = this.properties().mergeWith(withSameAggregation);
        return newMappings.equals(this.properties()) ? ImmutableRelationshipProjection.copyOf(this) : ImmutableRelationshipProjection.builder().from(this).properties(newMappings).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static RelationshipProjection create(Map<String, Object> config, Aggregation defaultAggregation, Function<PropertyMappings, RelationshipProjection> constructor) {
        Map properties = config.getOrDefault("properties", Collections.emptyMap());
        PropertyMappings propertyMappings = PropertyMappings.fromObject(properties, defaultAggregation);
        return constructor.apply(propertyMappings);
    }

    private static void validateConfigKeys(Map<String, Object> map) {
        ConfigKeyValidation.requireOnlyKeysFrom(List.of(TYPE_KEY, ORIENTATION_KEY, AGGREGATION_KEY, "properties", INDEX_INVERSE_KEY), map.keySet());
    }

    @Builder.AccessibleFields
    public static final class Builder
    extends ImmutableRelationshipProjection.Builder
    implements ElementProjection.InlineProperties<Builder> {
        private ElementProjection.InlinePropertiesBuilder propertiesBuilder;

        Builder() {
        }

        @Override
        public RelationshipProjection build() {
            this.buildProperties();
            return super.build();
        }

        @Override
        public ElementProjection.InlinePropertiesBuilder inlineBuilder() {
            if (this.propertiesBuilder == null) {
                this.propertiesBuilder = new ElementProjection.InlinePropertiesBuilder(() -> this.properties, newProperties -> {
                    this.properties = newProperties;
                });
            }
            return this.propertiesBuilder;
        }
    }
}

