/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.ElementIdentifier;

public class RelationshipType
extends ElementIdentifier {
    public static final RelationshipType ALL_RELATIONSHIPS = RelationshipType.of("__ALL__");

    public RelationshipType(String name) {
        super(name, "Relationship type");
    }

    @Override
    public ElementIdentifier projectAll() {
        return ALL_RELATIONSHIPS;
    }

    public static RelationshipType of(@NotNull String name) {
        return new RelationshipType(name);
    }

    public static String toString(RelationshipType relType) {
        return relType.name();
    }

    public static Collection<RelationshipType> listOf(String ... relationshipTypes) {
        return Arrays.stream(relationshipTypes).map(RelationshipType::of).collect(Collectors.toList());
    }
}

