/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.api.nodeproperties;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.DefaultValue;

public enum ValueType {
    LONG{

        @Override
        public String cypherName() {
            return "Integer";
        }

        @Override
        public String csvName() {
            return "long";
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.forLong();
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitLong();
        }
    }
    ,
    DOUBLE{

        @Override
        public String cypherName() {
            return "Float";
        }

        @Override
        public String csvName() {
            return "double";
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.forDouble();
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitDouble();
        }
    }
    ,
    STRING{

        @Override
        public String cypherName() {
            return "String";
        }

        @Override
        public String csvName() {
            return "string";
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.DEFAULT;
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitString();
        }
    }
    ,
    DOUBLE_ARRAY{

        @Override
        public String cypherName() {
            return "List of Float";
        }

        @Override
        public String csvName() {
            return "double[]";
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.forDoubleArray();
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitDoubleArray();
        }
    }
    ,
    FLOAT_ARRAY{

        @Override
        public String cypherName() {
            return "List of Float";
        }

        @Override
        public String csvName() {
            return "float[]";
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.forFloatArray();
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitFloatArray();
        }
    }
    ,
    LONG_ARRAY{

        @Override
        public String cypherName() {
            return "List of Integer";
        }

        @Override
        public String csvName() {
            return "long[]";
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.forLongArray();
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitLongArray();
        }
    }
    ,
    UNKNOWN{

        @Override
        public String cypherName() {
            return "Unknown";
        }

        @Override
        public String csvName() {
            throw new UnsupportedOperationException("Value Type UKNONWN is not supported in CSV");
        }

        @Override
        public DefaultValue fallbackValue() {
            return DefaultValue.DEFAULT;
        }

        @Override
        public <RESULT> RESULT accept(Visitor<RESULT> visitor) {
            return visitor.visitUnknown();
        }
    };


    public abstract String cypherName();

    public abstract String csvName();

    public abstract DefaultValue fallbackValue();

    public abstract <RESULT> RESULT accept(Visitor<RESULT> var1);

    public static ValueType fromCsvName(String csvName) {
        for (ValueType value : ValueType.values()) {
            if (value == UNKNOWN || !value.csvName().equals(csvName)) continue;
            return value;
        }
        throw new IllegalArgumentException("Unexpected value: " + csvName);
    }

    public static interface Visitor<RESULT> {
        public RESULT visitLong();

        public RESULT visitDouble();

        public RESULT visitString();

        public RESULT visitLongArray();

        public RESULT visitDoubleArray();

        public RESULT visitFloatArray();

        @Nullable
        default public RESULT visitUnknown() {
            return null;
        }
    }
}

