/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core.utils;

import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public final class CollectionUtil {
    public static <T> Stream<IntObjectPair<T>> enumerate(Collection<T> items) {
        int size = items.size();
        if (items instanceof List && items instanceof RandomAccess) {
            List list = (List)items;
            return IntStream.range(0, size).mapToObj(idx -> PrimitiveTuples.pair((int)idx, list.get(idx)));
        }
        AtomicInteger index = new AtomicInteger();
        return items.stream().map(item -> PrimitiveTuples.pair((int)index.getAndIncrement(), (Object)item));
    }

    private CollectionUtil() {
        throw new UnsupportedOperationException("No instances");
    }
}

