/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.output.WriterOutputStream;
import org.eclipse.collections.api.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.gds.compat.CompatAccessMode42;
import org.neo4j.gds.compat.CompatGraphDatabaseAPI42;
import org.neo4j.gds.compat.CompatIndexQuery;
import org.neo4j.gds.compat.CompatIndexQuery42;
import org.neo4j.gds.compat.CompatInput;
import org.neo4j.gds.compat.CompatUsernameAuthSubject42;
import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.CompositeNodeCursor42;
import org.neo4j.gds.compat.CustomAccessMode;
import org.neo4j.gds.compat.GdsGraphDatabaseAPI;
import org.neo4j.gds.compat.InternalReadOps;
import org.neo4j.gds.compat.JobRunner;
import org.neo4j.gds.compat.JobRunner42;
import org.neo4j.gds.compat.LongPropertyReference;
import org.neo4j.gds.compat.MemoryTrackerProxy;
import org.neo4j.gds.compat.MemoryTrackerProxy42;
import org.neo4j.gds.compat.Neo4jProxyApi;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.compat.ScanBasedStoreScan42;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.OffHeapLongArray;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionMonitors;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.security.RestrictedAccessMode;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Mode;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.storable.ValueGroup;

public final class Neo4jProxy42
implements Neo4jProxyApi {
    public GdsGraphDatabaseAPI newDb(DatabaseManagementService dbms) {
        return new CompatGraphDatabaseAPI42(dbms);
    }

    public AccessMode accessMode(CustomAccessMode customAccessMode) {
        return new CompatAccessMode42(customAccessMode);
    }

    public AccessMode newRestrictedAccessMode(AccessMode original, AccessMode.Static restricting) {
        return new RestrictedAccessMode(original, restricting);
    }

    public SecurityContext securityContext(String username, AuthSubject authSubject, AccessMode mode, String databaseName) {
        return new SecurityContext((AuthSubject)new CompatUsernameAuthSubject42(username, authSubject), mode);
    }

    public long getHighestPossibleIdInUse(RecordStore<? extends AbstractBaseRecord> recordStore, KernelTransaction kernelTransaction) {
        return recordStore.getHighestPossibleIdInUse(kernelTransaction.pageCursorTracer());
    }

    public PageCursor pageFileIO(PagedFile pagedFile, long pageId, int pageFileFlags) throws IOException {
        return pagedFile.io(pageId, pageFileFlags, PageCursorTracer.NULL);
    }

    public PagedFile pageCacheMap(PageCache pageCache, File file, int pageSize, String databaseName, OpenOption ... openOptions) throws IOException {
        return pageCache.map(file.toPath(), pageSize, Sets.immutable.of((Object[])openOptions));
    }

    public Path pagedFile(PagedFile pagedFile) {
        return pagedFile.path();
    }

    public List<StoreScan<NodeLabelIndexCursor>> entityCursorScan(KernelTransaction transaction, int[] labelIds, int batchSize) {
        Read read = transaction.dataRead();
        read.prepareForLabelScans();
        return Arrays.stream(labelIds).mapToObj(arg_0 -> ((Read)read).nodeLabelScan(arg_0)).map(scan -> this.scanToStoreScan((Scan)scan, batchSize)).collect(Collectors.toList());
    }

    public PropertyCursor allocatePropertyCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocatePropertyCursor(kernelTransaction.pageCursorTracer(), kernelTransaction.memoryTracker());
    }

    public PropertyReference propertyReference(NodeCursor nodeCursor) {
        return LongPropertyReference.of((long)nodeCursor.propertiesReference());
    }

    public PropertyReference propertyReference(RelationshipScanCursor relationshipScanCursor) {
        return LongPropertyReference.of((long)relationshipScanCursor.propertiesReference());
    }

    public PropertyReference noPropertyReference() {
        return LongPropertyReference.empty();
    }

    public void nodeProperties(KernelTransaction kernelTransaction, long nodeReference, PropertyReference reference, PropertyCursor cursor) {
        kernelTransaction.dataRead().nodeProperties(nodeReference, ((LongPropertyReference)reference).id, cursor);
    }

    public void relationshipProperties(KernelTransaction kernelTransaction, long relationshipReference, PropertyReference reference, PropertyCursor cursor) {
        kernelTransaction.dataRead().relationshipProperties(relationshipReference, ((LongPropertyReference)reference).id, cursor);
    }

    public NodeCursor allocateNodeCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeCursor(kernelTransaction.pageCursorTracer());
    }

    public RelationshipScanCursor allocateRelationshipScanCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateRelationshipScanCursor(kernelTransaction.pageCursorTracer());
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeLabelIndexCursor(kernelTransaction.pageCursorTracer());
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.pageCursorTracer(), kernelTransaction.memoryTracker());
    }

    public long relationshipsReference(NodeCursor nodeCursor) {
        return nodeCursor.relationshipsReference();
    }

    public boolean hasNodeLabelIndex(KernelTransaction kernelTransaction) {
        return true;
    }

    public void nodeLabelScan(KernelTransaction kernelTransaction, int label, NodeLabelIndexCursor cursor) {
        kernelTransaction.dataRead().nodeLabelScan(label, cursor, IndexOrder.NONE);
    }

    public StoreScan<NodeLabelIndexCursor> nodeLabelIndexScan(KernelTransaction transaction, int labelId, int batchSize) {
        Read read = transaction.dataRead();
        read.prepareForLabelScans();
        return this.scanToStoreScan(read.nodeLabelScan(labelId), batchSize);
    }

    public <C extends Cursor> StoreScan<C> scanToStoreScan(Scan<C> scan, int batchSize) {
        return new ScanBasedStoreScan42<C>(scan, batchSize);
    }

    public void nodeIndexScan(Read dataRead, IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues) throws Exception {
        IndexQueryConstraints indexQueryConstraints = indexOrder == IndexOrder.NONE ? IndexQueryConstraints.unordered((boolean)needsValues) : IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)needsValues);
        dataRead.nodeIndexScan(index, cursor, indexQueryConstraints);
    }

    public CompatIndexQuery rangeIndexQuery(int propertyKeyId, double from, boolean fromInclusive, double to, boolean toInclusive) {
        return new CompatIndexQuery42((IndexQuery)IndexQuery.range((int)propertyKeyId, (Number)from, (boolean)fromInclusive, (Number)to, (boolean)toInclusive));
    }

    public CompatIndexQuery rangeAllIndexQuery(int propertyKeyId) {
        return new CompatIndexQuery42((IndexQuery)IndexQuery.range((int)propertyKeyId, (ValueGroup)ValueGroup.NUMBER));
    }

    public void nodeIndexSeek(Read dataRead, IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues, CompatIndexQuery query) throws Exception {
        IndexQueryConstraints indexQueryConstraints = indexOrder == IndexOrder.NONE ? IndexQueryConstraints.unordered((boolean)needsValues) : IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)needsValues);
        dataRead.nodeIndexSeek(index, cursor, indexQueryConstraints, new IndexQuery[]{((CompatIndexQuery42)query).indexQuery});
    }

    public CompositeNodeCursor compositeNodeCursor(List<NodeLabelIndexCursor> cursors, int[] labelIds) {
        return new CompositeNodeCursor42(cursors, labelIds);
    }

    public OffHeapLongArray newOffHeapLongArray(long length, long defaultValue, long base) {
        return new OffHeapLongArray(length, defaultValue, base, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public LongArray newChunkedLongArray(NumberArrayFactory numberArrayFactory, int size, long defaultValue) {
        return numberArrayFactory.newLongArray((long)size, defaultValue, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public MemoryTrackerProxy memoryTrackerProxy(KernelTransaction kernelTransaction) {
        return MemoryTrackerProxy42.of(kernelTransaction.memoryTracker());
    }

    public MemoryTrackerProxy emptyMemoryTracker() {
        return MemoryTrackerProxy42.of((MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public MemoryTrackerProxy limitedMemoryTracker(long limitInBytes, long grabSizeInBytes) {
        return MemoryTrackerProxy42.of((MemoryTracker)new LocalMemoryTracker((MemoryPool)MemoryPools.NO_TRACKING, limitInBytes, grabSizeInBytes, "setting"));
    }

    public LogService logProviderForStoreAndRegister(Path storeLogPath, FileSystemAbstraction fs, LifeSupport lifeSupport) {
        Neo4jLoggerContext neo4jLoggerContext = LogConfig.createBuilder((FileSystemAbstraction)fs, (Path)storeLogPath, (Level)Level.INFO).build();
        SimpleLogService simpleLogService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)new Log4jLogProvider(neo4jLoggerContext));
        return (LogService)lifeSupport.add((Lifecycle)simpleLogService);
    }

    public Path metadataStore(DatabaseLayout databaseLayout) {
        return databaseLayout.metadataStore();
    }

    public Path homeDirectory(DatabaseLayout databaseLayout) {
        return databaseLayout.getNeo4jLayout().homeDirectory();
    }

    public BatchImporter instantiateBatchImporter(BatchImporterFactory factory, DatabaseLayout directoryStructure, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, final int writeConcurrency, final Optional<Long> pageCacheMemory, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats, ImportLogic.Monitor monitor, JobScheduler jobScheduler, Collector badCollector) {
        Configuration importerConfig = new Configuration(){

            public int maxNumberOfProcessors() {
                return writeConcurrency;
            }

            public long pageCacheMemory() {
                return pageCacheMemory.orElseGet(() -> super.pageCacheMemory());
            }

            public boolean highIO() {
                return false;
            }
        };
        return factory.instantiate(directoryStructure, fileSystem, null, pageCacheTracer, importerConfig, logService, executionMonitor, additionalInitialIds, dbConfig, recordFormats, monitor, jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public Input batchInputFrom(CompatInput compatInput) {
        return new InputFromCompatInput(compatInput);
    }

    public String queryText(ExecutingQuery query) {
        return query.rawQueryText();
    }

    public Log logger(Level level, ZoneId zoneId, DateTimeFormatter dateTimeFormatter, String category, PrintWriter writer) {
        WriterOutputStream outStream = new WriterOutputStream((Writer)writer, StandardCharsets.UTF_8);
        return this.logger(level, zoneId, dateTimeFormatter, category, (OutputStream)outStream);
    }

    public Log logger(Level level, ZoneId zoneId, DateTimeFormatter dateTimeFormatter, String category, OutputStream outputStream) {
        LogTimeZone logTimeZone = Arrays.stream(LogTimeZone.values()).filter(tz -> tz.getZoneId().equals(zoneId)).findAny().orElseThrow(() -> new IllegalArgumentException("Can only log in UTC or " + LogTimeZone.SYSTEM.getZoneId()));
        Neo4jLoggerContext context = LogConfig.createBuilder((OutputStream)outputStream, (Level)level).withCategory(category != null).withTimezone(logTimeZone).build();
        return new Log4jLogProvider(context).getLog(category != null ? category : "");
    }

    public Setting<Boolean> onlineBackupEnabled() {
        try {
            Class<?> onlineSettingsClass = Class.forName("com.neo4j.configuration.OnlineBackupSettings");
            Object onlineBackupEnabled = MethodHandles.lookup().findStaticGetter(onlineSettingsClass, "online_backup_enabled", Setting.class).invoke();
            return (Setting)onlineBackupEnabled;
        }
        catch (Throwable e) {
            throw new IllegalStateException("The online_backup_enabled setting requires Neo4j Enterprise Edition to be available.");
        }
    }

    public Setting<String> additionalJvm() {
        return ExternalSettings.additional_jvm;
    }

    public Setting<Long> memoryTransactionMaxSize() {
        return GraphDatabaseSettings.memory_transaction_max_size;
    }

    public JobRunner runnerFromScheduler(JobScheduler scheduler, Group group) {
        return new JobRunner42(scheduler, group);
    }

    public ExecutionMonitor invisibleExecutionMonitor() {
        return ExecutionMonitors.invisible();
    }

    public UserFunctionSignature userFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String deprecated, String[] allowed, String description, String category, boolean caseInsensitive) {
        return new UserFunctionSignature(name, inputSignature, type, deprecated, allowed, description, category, caseInsensitive);
    }

    public ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String[] allowed, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials) {
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated, allowed, description, warning, eager, caseInsensitive, systemProcedure, internal);
    }

    public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(GlobalProcedures registry, Class<T> cls, boolean safe) {
        return registry.lookupComponentProvider(cls, safe);
    }

    public long getHighestPossibleNodeCount(Read read, IdGeneratorFactory idGeneratorFactory) {
        return InternalReadOps.countByIdGenerator((IdGeneratorFactory)idGeneratorFactory, (IdType)IdType.NODE).orElseGet(() -> ((Read)read).nodesGetCount());
    }

    public long getHighestPossibleRelationshipCount(Read read, IdGeneratorFactory idGeneratorFactory) {
        return InternalReadOps.countByIdGenerator((IdGeneratorFactory)idGeneratorFactory, (IdType)IdType.RELATIONSHIP).orElseGet(() -> ((Read)read).relationshipsGetCount());
    }

    private static final class InputFromCompatInput
    implements Input {
        private final CompatInput delegate;

        private InputFromCompatInput(CompatInput delegate) {
            this.delegate = delegate;
        }

        public InputIterable nodes(Collector badCollector) {
            return this.delegate.nodes(badCollector);
        }

        public InputIterable relationships(Collector badCollector) {
            return this.delegate.relationships(badCollector);
        }

        public org.neo4j.internal.batchimport.input.IdType idType() {
            return this.delegate.idType();
        }

        public ReadableGroups groups() {
            return this.delegate.groups();
        }

        public Input.Estimates calculateEstimates(PropertySizeCalculator propertySizeCalculator) throws IOException {
            return this.delegate.calculateEstimates((values, kernelTransaction) -> propertySizeCalculator.calculateSize(values, kernelTransaction.pageCursorTracer(), kernelTransaction.memoryTracker()));
        }
    }
}

