/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._43;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.configuration.helpers.DatabaseNameValidator;
import org.neo4j.configuration.helpers.NormalizedDatabaseName;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.compat.BoltTransactionRunner;
import org.neo4j.gds.compat.CompatExecutionMonitor;
import org.neo4j.gds.compat.CompatIndexQuery;
import org.neo4j.gds.compat.CompatInput;
import org.neo4j.gds.compat.CompositeNodeCursor;
import org.neo4j.gds.compat.CustomAccessMode;
import org.neo4j.gds.compat.GdsDatabaseManagementServiceBuilder;
import org.neo4j.gds.compat.GdsGraphDatabaseAPI;
import org.neo4j.gds.compat.InternalReadOps;
import org.neo4j.gds.compat.LongPropertyReference;
import org.neo4j.gds.compat.Neo4jProxyApi;
import org.neo4j.gds.compat.PropertyReference;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.compat.TestLog;
import org.neo4j.gds.compat._43.BoltTransactionRunnerImpl;
import org.neo4j.gds.compat._43.CompatAccessModeImpl;
import org.neo4j.gds.compat._43.CompatGraphDatabaseAPIImpl;
import org.neo4j.gds.compat._43.CompatIndexQueryImpl;
import org.neo4j.gds.compat._43.CompatUsernameAuthSubjectImpl;
import org.neo4j.gds.compat._43.CompositeNodeCursorImpl;
import org.neo4j.gds.compat._43.GdsDatabaseManagementServiceBuilderImpl;
import org.neo4j.gds.compat._43.NodeLabelIndexLookupImpl;
import org.neo4j.gds.compat._43.ScanBasedStoreScanImpl;
import org.neo4j.gds.compat._43.TestLogImpl;
import org.neo4j.gds.compat._43.VirtualRelationshipImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.ImportLogic;
import org.neo4j.internal.batchimport.IndexConfig;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.InputIterable;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.PropertySizeCalculator;
import org.neo4j.internal.batchimport.input.ReadableGroups;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.helpers.HostnamePort;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Mode;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.ssl.config.SslPolicyLoader;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;

public final class Neo4jProxyImpl
implements Neo4jProxyApi {
    public GdsGraphDatabaseAPI newDb(DatabaseManagementService dbms) {
        return new CompatGraphDatabaseAPIImpl(dbms);
    }

    public String validateExternalDatabaseName(String databaseName) {
        NormalizedDatabaseName normalizedName = new NormalizedDatabaseName(databaseName);
        DatabaseNameValidator.validateExternalDatabaseName((NormalizedDatabaseName)normalizedName);
        return normalizedName.name();
    }

    public AccessMode accessMode(CustomAccessMode customAccessMode) {
        return new CompatAccessModeImpl(customAccessMode);
    }

    public String username(AuthSubject subject) {
        return subject.username();
    }

    public SecurityContext securityContext(String username, AuthSubject authSubject, AccessMode mode, String databaseName) {
        return new SecurityContext((AuthSubject)new CompatUsernameAuthSubjectImpl(username, authSubject), mode, ClientConnectionInfo.EMBEDDED_CONNECTION, databaseName);
    }

    public long getHighestPossibleIdInUse(RecordStore<? extends AbstractBaseRecord> recordStore, KernelTransaction kernelTransaction) {
        return recordStore.getHighestPossibleIdInUse(kernelTransaction.cursorContext());
    }

    public List<StoreScan<NodeLabelIndexCursor>> entityCursorScan(KernelTransaction transaction, int[] labelIds, int batchSize, boolean allowPartitionedScan) {
        Read read = transaction.dataRead();
        return Arrays.stream(labelIds).mapToObj(arg_0 -> ((Read)read).nodeLabelScan(arg_0)).map(scan -> this.scanToStoreScan((Scan)scan, batchSize)).collect(Collectors.toList());
    }

    public PropertyCursor allocatePropertyCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocatePropertyCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());
    }

    public PropertyReference propertyReference(NodeCursor nodeCursor) {
        return LongPropertyReference.of((long)nodeCursor.propertiesReference());
    }

    public PropertyReference propertyReference(RelationshipScanCursor relationshipScanCursor) {
        return LongPropertyReference.of((long)relationshipScanCursor.propertiesReference());
    }

    public PropertyReference noPropertyReference() {
        return LongPropertyReference.empty();
    }

    public void nodeProperties(KernelTransaction kernelTransaction, long nodeReference, PropertyReference reference, PropertyCursor cursor) {
        kernelTransaction.dataRead().nodeProperties(nodeReference, ((LongPropertyReference)reference).id, cursor);
    }

    public void relationshipProperties(KernelTransaction kernelTransaction, long relationshipReference, PropertyReference reference, PropertyCursor cursor) {
        kernelTransaction.dataRead().relationshipProperties(relationshipReference, ((LongPropertyReference)reference).id, cursor);
    }

    public NodeCursor allocateNodeCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeCursor(kernelTransaction.cursorContext());
    }

    public RelationshipScanCursor allocateRelationshipScanCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateRelationshipScanCursor(kernelTransaction.cursorContext());
    }

    public NodeLabelIndexCursor allocateNodeLabelIndexCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeLabelIndexCursor(kernelTransaction.cursorContext());
    }

    public NodeValueIndexCursor allocateNodeValueIndexCursor(KernelTransaction kernelTransaction) {
        return kernelTransaction.cursors().allocateNodeValueIndexCursor(kernelTransaction.cursorContext(), kernelTransaction.memoryTracker());
    }

    public boolean hasNodeLabelIndex(KernelTransaction kernelTransaction) {
        return NodeLabelIndexLookupImpl.hasNodeLabelIndex(kernelTransaction);
    }

    public StoreScan<NodeLabelIndexCursor> nodeLabelIndexScan(KernelTransaction transaction, int labelId, int batchSize, boolean allowPartitionedScan) {
        Read read = transaction.dataRead();
        return this.scanToStoreScan(read.nodeLabelScan(labelId), batchSize);
    }

    public <C extends Cursor> StoreScan<C> scanToStoreScan(Scan<C> scan, int batchSize) {
        return new ScanBasedStoreScanImpl<C>(scan, batchSize);
    }

    public CompatIndexQuery rangeIndexQuery(int propertyKeyId, double from, boolean fromInclusive, double to, boolean toInclusive) {
        return new CompatIndexQueryImpl((PropertyIndexQuery)PropertyIndexQuery.range((int)propertyKeyId, (Number)from, (boolean)fromInclusive, (Number)to, (boolean)toInclusive));
    }

    public CompatIndexQuery rangeAllIndexQuery(int propertyKeyId) {
        return new CompatIndexQueryImpl((PropertyIndexQuery)PropertyIndexQuery.range((int)propertyKeyId, (ValueGroup)ValueGroup.NUMBER));
    }

    public void nodeIndexSeek(Read dataRead, IndexReadSession index, NodeValueIndexCursor cursor, IndexOrder indexOrder, boolean needsValues, CompatIndexQuery query) throws KernelException {
        IndexQueryConstraints indexQueryConstraints = indexOrder == IndexOrder.NONE ? IndexQueryConstraints.unordered((boolean)needsValues) : IndexQueryConstraints.constrained((IndexOrder)indexOrder, (boolean)needsValues);
        dataRead.nodeIndexSeek(index, cursor, indexQueryConstraints, new PropertyIndexQuery[]{((CompatIndexQueryImpl)query).indexQuery});
    }

    public CompositeNodeCursor compositeNodeCursor(List<NodeLabelIndexCursor> cursors, int[] labelIds) {
        return new CompositeNodeCursorImpl(cursors, labelIds);
    }

    public Configuration batchImporterConfig(final int batchSize, final int writeConcurrency, final Optional<Long> pageCacheMemory, final boolean highIO, final IndexConfig indexConfig) {
        return new Configuration(){

            public int batchSize() {
                return batchSize;
            }

            public int maxNumberOfProcessors() {
                return writeConcurrency;
            }

            public long pageCacheMemory() {
                return pageCacheMemory.orElseGet(() -> super.pageCacheMemory());
            }

            public boolean highIO() {
                return highIO;
            }

            public IndexConfig indexConfig() {
                return indexConfig;
            }
        };
    }

    public int writeConcurrency(Configuration batchImportConfiguration) {
        return batchImportConfiguration.maxNumberOfProcessors();
    }

    public BatchImporter instantiateBatchImporter(BatchImporterFactory factory, DatabaseLayout directoryStructure, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, Configuration configuration, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats, JobScheduler jobScheduler, Collector badCollector) {
        return factory.instantiate(directoryStructure, fileSystem, pageCacheTracer, configuration, logService, executionMonitor, additionalInitialIds, dbConfig, recordFormats, ImportLogic.NO_MONITOR, jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(dbConfig), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public Input batchInputFrom(CompatInput compatInput) {
        return new InputFromCompatInput(compatInput);
    }

    public Setting<String> additionalJvm() {
        return BootloaderSettings.additional_jvm;
    }

    public Setting<String> pageCacheMemory() {
        return GraphDatabaseSettings.pagecache_memory;
    }

    public String pageCacheMemoryValue(String value) {
        return value;
    }

    public ExecutionMonitor invisibleExecutionMonitor() {
        return ExecutionMonitor.INVISIBLE;
    }

    public ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials) {
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated, new String[0], description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials);
    }

    public long getHighestPossibleNodeCount(Read read, IdGeneratorFactory idGeneratorFactory) {
        return InternalReadOps.countByIdGenerator((IdGeneratorFactory)idGeneratorFactory, (IdType)IdType.NODE).orElseGet(() -> ((Read)read).nodesGetCount());
    }

    public long getHighestPossibleRelationshipCount(Read read, IdGeneratorFactory idGeneratorFactory) {
        return InternalReadOps.countByIdGenerator((IdGeneratorFactory)idGeneratorFactory, (IdType)IdType.RELATIONSHIP).orElseGet(() -> ((Read)read).relationshipsGetCount());
    }

    public String versionLongToString(long storeVersion) {
        return MetaDataStore.versionLongToString((long)storeVersion);
    }

    public TestLog testLog() {
        return new TestLogImpl();
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public Log getUserLog(LogService logService, Class<?> loggingClass) {
        return logService.getUserLog(loggingClass);
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public Log getInternalLog(LogService logService, Class<?> loggingClass) {
        return logService.getInternalLog(loggingClass);
    }

    public Relationship virtualRelationship(long id, Node startNode, Node endNode, RelationshipType type) {
        return new VirtualRelationshipImpl(id, startNode, endNode, type);
    }

    public GdsDatabaseManagementServiceBuilder databaseManagementServiceBuilder(Path storeDir) {
        return new GdsDatabaseManagementServiceBuilderImpl(storeDir);
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public RecordFormats selectRecordFormatForStore(DatabaseLayout databaseLayout, FileSystemAbstraction fs, PageCache pageCache, LogService logService, PageCacheTracer pageCacheTracer) {
        return RecordFormatSelector.selectForStore((DatabaseLayout)databaseLayout, (FileSystemAbstraction)fs, (PageCache)pageCache, (LogProvider)logService.getInternalLogProvider(), (PageCacheTracer)PageCacheTracer.NULL);
    }

    public boolean isNotNumericIndex(IndexCapability indexCapability) {
        return indexCapability.valueCapability(new ValueCategory[]{ValueCategory.NUMBER}) != IndexValueCapability.YES;
    }

    public void setAllowUpgrades(Config.Builder configBuilder, boolean value) {
        configBuilder.set(GraphDatabaseSettings.allow_upgrade, (Object)value);
    }

    public String defaultRecordFormatSetting() {
        return (String)GraphDatabaseSettings.record_format.defaultValue();
    }

    public void configureRecordFormat(Config.Builder configBuilder, String recordFormat) {
        configBuilder.set(GraphDatabaseSettings.record_format, (Object)recordFormat);
    }

    public DatabaseLayout databaseLayout(Config config, String databaseName) {
        return Neo4jLayout.of((Config)config).databaseLayout(databaseName);
    }

    public BoltTransactionRunner<?, ?> boltTransactionRunner() {
        return new BoltTransactionRunnerImpl();
    }

    public HostnamePort getLocalBoltAddress(ConnectorPortRegister connectorPortRegister) {
        return connectorPortRegister.getLocalAddress("bolt");
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public SslPolicyLoader createSllPolicyLoader(FileSystemAbstraction fileSystem, Config config, LogService logService) {
        return SslPolicyLoader.create((Config)config, (LogProvider)logService.getInternalLogProvider());
    }

    @SuppressForbidden(reason="This is the compat specific use")
    public RecordFormats recordFormatSelector(String databaseName, Config databaseConfig, FileSystemAbstraction fs, LogService logService, GraphDatabaseService databaseService) {
        return RecordFormatSelector.selectForConfig((Config)databaseConfig, (LogProvider)logService.getInternalLogProvider());
    }

    public NamedDatabaseId randomDatabaseId() {
        return (NamedDatabaseId)new TestDatabaseIdRepository().getByName(UUID.randomUUID().toString()).orElseThrow();
    }

    public ExecutionMonitor executionMonitor(final CompatExecutionMonitor compatExecutionMonitor) {
        return new ExecutionMonitor.Adapter(compatExecutionMonitor.clock(), compatExecutionMonitor.checkIntervalMillis(), TimeUnit.MILLISECONDS){

            public void initialize(DependencyResolver dependencyResolver) {
                compatExecutionMonitor.initialize(dependencyResolver);
            }

            public void start(StageExecution execution) {
                compatExecutionMonitor.start(execution);
            }

            public void end(StageExecution execution, long totalTimeMillis) {
                compatExecutionMonitor.end(execution, totalTimeMillis);
            }

            public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
                compatExecutionMonitor.done(successful, totalTimeMillis, additionalInformation);
            }

            public void check(StageExecution execution) {
                compatExecutionMonitor.check(execution);
            }
        };
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public UserFunctionSignature userFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String description, boolean internal, boolean threadSafe) {
        String deprecated = null;
        String category = null;
        String[] allowed = new String[]{};
        boolean caseInsensitive = false;
        boolean isBuiltIn = false;
        return new UserFunctionSignature(name, inputSignature, type, deprecated, allowed, description, category, caseInsensitive, isBuiltIn, internal);
    }

    public long transactionId(KernelTransactionHandle kernelTransactionHandle) {
        return kernelTransactionHandle.lastTransactionTimestampWhenStarted();
    }

    public void reserveNeo4jIds(IdGeneratorFactory generatorFactory, int size, CursorContext cursorContext) {
        IdGenerator idGenerator = generatorFactory.get(IdType.NODE);
        idGenerator.nextIdBatch(size, false, cursorContext);
    }

    private static final class InputFromCompatInput
    implements Input {
        private final CompatInput delegate;

        private InputFromCompatInput(CompatInput delegate) {
            this.delegate = delegate;
        }

        public InputIterable nodes(Collector badCollector) {
            return this.delegate.nodes(badCollector);
        }

        public InputIterable relationships(Collector badCollector) {
            return this.delegate.relationships(badCollector);
        }

        public org.neo4j.internal.batchimport.input.IdType idType() {
            return this.delegate.idType();
        }

        public ReadableGroups groups() {
            return this.delegate.groups();
        }

        public Input.Estimates calculateEstimates(PropertySizeCalculator propertySizeCalculator) throws IOException {
            return this.delegate.calculateEstimates((values, kernelTransaction) -> propertySizeCalculator.calculateSize(values, kernelTransaction.cursorContext(), kernelTransaction.memoryTracker()));
        }
    }
}

