/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._513;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.common.DependencyResolver;
import org.neo4j.gds.compat.BoltTransactionRunner;
import org.neo4j.gds.compat.CompatExecutionContext;
import org.neo4j.gds.compat.CustomAccessMode;
import org.neo4j.gds.compat.GlobalProcedureRegistry;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat._513.BoltTransactionRunnerImpl;
import org.neo4j.gds.compat._5x.CommonNeo4jProxyImpl;
import org.neo4j.gds.compat._5x.CompatAccessModeImpl;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.procedure.Mode;

public final class Neo4jProxyImpl
extends CommonNeo4jProxyImpl {
    private static final DependencyResolver EMPTY_DEPENDENCY_RESOLVER = new DependencyResolver(){

        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
            return null;
        }

        public boolean containsDependency(Class<?> type) {
            return false;
        }
    };

    public long getHighId(RecordStore<? extends AbstractBaseRecord> recordStore) {
        return recordStore.getIdGenerator().getHighId();
    }

    public <T> T lookupComponentProvider(Context ctx, Class<T> component, boolean safe) throws ProcedureException {
        GlobalProcedures globalProcedures = (GlobalProcedures)GraphDatabaseApiProxy.resolveDependency((DependencyResolver)ctx.dependencyResolver(), GlobalProcedures.class);
        return (T)globalProcedures.getCurrentView().lookupComponentProvider(component, safe).apply((Object)ctx);
    }

    public BoltTransactionRunner<?, ?> boltTransactionRunner() {
        return new BoltTransactionRunnerImpl();
    }

    public ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials, boolean threadSafe) {
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated, description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials, threadSafe);
    }

    public GlobalProcedureRegistry globalProcedureRegistry(final GlobalProcedures globalProcedures) {
        return new GlobalProcedureRegistry(){

            public Set<ProcedureSignature> getAllProcedures() {
                return globalProcedures.getCurrentView().getAllProcedures();
            }

            public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
                return globalProcedures.getCurrentView().getAllNonAggregatingFunctions();
            }

            public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
                return globalProcedures.getCurrentView().getAllAggregatingFunctions();
            }
        };
    }

    public DependencyResolver emptyDependencyResolver() {
        return EMPTY_DEPENDENCY_RESOLVER;
    }

    public CursorContextFactory cursorContextFactory(Optional<PageCacheTracer> pageCacheTracer) {
        return pageCacheTracer.map(cacheTracer -> new CursorContextFactory(cacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER)).orElse(CursorContextFactory.NULL_CONTEXT_FACTORY);
    }

    public CompatExecutionContext executionContext(KernelTransaction ktx) {
        final Statement stmt = ktx.acquireStatement();
        final ExecutionContext ctx = ktx.createExecutionContext();
        return new CompatExecutionContext(){

            public CursorContext cursorContext() {
                return ctx.cursorContext();
            }

            public AccessMode accessMode() {
                return ctx.securityContext().mode();
            }

            public <C extends Cursor> boolean reservePartition(PartitionedScan<C> scan, C cursor) {
                return scan.reservePartition(cursor, ctx);
            }

            public void close() {
                ctx.complete();
                ctx.close();
                stmt.close();
            }
        };
    }

    public AccessMode accessMode(CustomAccessMode customAccessMode) {
        return new CompatAccessModeImpl(customAccessMode){

            public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
                return this.custom.allowsReadNodeProperty(propertyKey);
            }
        };
    }

    public String neo4jArrowServerAddressHeader() {
        throw new UnsupportedOperationException("Not implemented for Neo4j versions <5.14");
    }

    public boolean isCompositeDatabase(GraphDatabaseService databaseService) {
        NamedDatabaseId databaseId = GraphDatabaseApiProxy.databaseId((GraphDatabaseService)databaseService);
        DatabaseReferenceRepository repo = (DatabaseReferenceRepository)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)databaseService, DatabaseReferenceRepository.class);
        return repo.getCompositeDatabaseReferences().stream().map(DatabaseReferenceImpl.Internal::databaseId).anyMatch(arg_0 -> ((NamedDatabaseId)databaseId).equals(arg_0));
    }

    public long estimateNodeCount(Read read, int label) {
        return read.countsForNodeWithoutTxState(label);
    }

    public long estimateRelationshipCount(Read read, int sourceLabel, int targetLabel, int type) {
        return read.countsForRelationshipWithoutTxState(sourceLabel, type, targetLabel);
    }

    public <T> T nodeLabelTokenSet(NodeCursor nodeCursor, Function<int[], T> intsConstructor, Function<long[], T> longsConstructor) {
        return longsConstructor.apply(nodeCursor.labels().all());
    }
}

