/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._521;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gds.compat.CompatMonitor;
import org.neo4j.gds.compat.GlobalProcedureRegistry;
import org.neo4j.gds.compat.Neo4jProxyApi;
import org.neo4j.gds.compat.Write;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.Mode;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.values.storable.Value;

public final class Neo4jProxyImpl
implements Neo4jProxyApi {
    public CursorContextFactory cursorContextFactory(Optional<PageCacheTracer> pageCacheTracer) {
        return pageCacheTracer.map(cacheTracer -> new CursorContextFactory(cacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER)).orElse(CursorContextFactory.NULL_CONTEXT_FACTORY);
    }

    public BatchImporter instantiateBlockBatchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, org.neo4j.internal.batchimport.Configuration configuration, CompatMonitor compatMonitor, LogService logService, AdditionalInitialIds additionalInitialIds, Config dbConfig, JobScheduler jobScheduler, Collector badCollector) {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((Configuration)dbConfig);
        PrintStream progressOutput = new PrintStream(PrintStream.nullOutputStream(), true, StandardCharsets.UTF_8);
        boolean verboseProgressOutput = false;
        return storageEngineFactory.batchImporter(databaseLayout, fileSystem, pageCacheTracer, configuration, logService, progressOutput, verboseProgressOutput, additionalInitialIds, dbConfig, Neo4jProxyImpl.toMonitor(compatMonitor), jobScheduler, badCollector, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.cursorContextFactory(Optional.empty()));
    }

    private static Monitor toMonitor(final CompatMonitor compatMonitor) {
        return new Monitor(){

            public void started() {
                compatMonitor.started();
            }

            public void percentageCompleted(int percentage) {
                compatMonitor.percentageCompleted(percentage);
            }

            public void completed(boolean success) {
                compatMonitor.completed(success);
            }
        };
    }

    public GlobalProcedureRegistry globalProcedureRegistry(final GlobalProcedures globalProcedures) {
        return new GlobalProcedureRegistry(){

            public Stream<ProcedureSignature> getAllProcedures() {
                return globalProcedures.getCurrentView().getAllProcedures(CypherScope.CYPHER_5);
            }

            public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
                return globalProcedures.getCurrentView().getAllNonAggregatingFunctions(CypherScope.CYPHER_5);
            }

            public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
                return globalProcedures.getCurrentView().getAllAggregatingFunctions(CypherScope.CYPHER_5);
            }
        };
    }

    public Write dataWrite(KernelTransaction kernelTransaction) throws InvalidTransactionTypeKernelException {
        final org.neo4j.internal.kernel.api.Write neoWrite = kernelTransaction.dataWrite();
        return new Write(){

            public void nodeAddLabel(long node, int nodeLabelToken) throws KernelException {
                neoWrite.nodeAddLabel(node, nodeLabelToken);
            }

            public void nodeSetProperty(long node, int propertyKey, Value value) throws KernelException {
                neoWrite.nodeSetProperty(node, propertyKey, value);
            }

            public long relationshipCreate(long source, int relationshipToken, long target) throws KernelException {
                return neoWrite.relationshipCreate(source, relationshipToken, target);
            }

            public void relationshipSetProperty(long relationship, int propertyKey, Value value) throws KernelException {
                neoWrite.relationshipSetProperty(relationship, propertyKey, value);
            }
        };
    }

    public ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, Optional<String> deprecatedBy, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials, boolean threadSafe) {
        Optional<String> deprecated = deprecatedBy.filter(Predicate.not(String::isEmpty));
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated.isPresent(), (String)deprecated.orElse(null), description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials, threadSafe, CypherScope.ALL_SCOPES);
    }

    public UserFunctionSignature userFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String description, Optional<String> deprecatedBy, boolean internal, boolean threadSafe) {
        String category = null;
        boolean caseInsensitive = false;
        boolean isBuiltIn = false;
        Optional<String> deprecated = deprecatedBy.filter(Predicate.not(String::isEmpty));
        return new UserFunctionSignature(name, inputSignature, type, deprecated.isPresent(), (String)deprecated.orElse(null), description, category, caseInsensitive, isBuiltIn, internal, threadSafe, CypherScope.ALL_SCOPES);
    }
}

