/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._523;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.neo4j.batchimport.api.IndexConfig;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.configuration.Config;
import org.neo4j.gds.compat.batchimport.BatchImporter;
import org.neo4j.gds.compat.batchimport.ImportConfig;
import org.neo4j.gds.compat.batchimport.InputIterable;
import org.neo4j.gds.compat.batchimport.InputIterator;
import org.neo4j.gds.compat.batchimport.input.Estimates;
import org.neo4j.gds.compat.batchimport.input.InputEntityVisitor;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.batchimport.DefaultAdditionalIds;
import org.neo4j.internal.batchimport.input.Collectors;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.index.schema.IndexImporterFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;

public final class BatchImporterCompat {
    private static final Input.Estimates NULL_ESTIMATES = Input.knownEstimates((long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);

    private BatchImporterCompat() {
    }

    static BatchImporter instantiateBatchImporter(DatabaseLayout dbLayout, FileSystemAbstraction fileSystem, ImportConfig config, org.neo4j.gds.compat.batchimport.Monitor monitor, LogService logService, Config dbConfig, JobScheduler jobScheduler, org.neo4j.gds.compat.batchimport.input.Collector badCollector) {
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.selectStorageEngine((Configuration)dbConfig);
        PrintStream progressOutput = new PrintStream(PrintStream.nullOutputStream(), true, StandardCharsets.UTF_8);
        boolean verboseProgressOutput = false;
        org.neo4j.batchimport.api.BatchImporter importer = storageEngineFactory.batchImporter(dbLayout, fileSystem, PageCacheTracer.NULL, (org.neo4j.batchimport.api.Configuration)new ConfigurationAdapter(config), logService, progressOutput, verboseProgressOutput, DefaultAdditionalIds.EMPTY, dbConfig, (Monitor)new MonitorAdapter(monitor), jobScheduler, badCollector != null ? ((CollectorAdapter)badCollector).delegate : null, TransactionLogInitializer.getLogFilesInitializer(), (IndexImporterFactory)new IndexImporterFactoryImpl(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, CursorContextFactory.NULL_CONTEXT_FACTORY);
        return new BatchImporterReverseAdapter(importer);
    }

    private static org.neo4j.gds.compat.batchimport.input.Group adaptGroup(Group group) {
        return new GroupReverseAdapter(group);
    }

    private static IdType adaptIdType(org.neo4j.gds.compat.batchimport.input.IdType idType) {
        return switch (idType) {
            default -> throw new IncompatibleClassChangeError();
            case org.neo4j.gds.compat.batchimport.input.IdType.ACTUAL -> IdType.ACTUAL;
            case org.neo4j.gds.compat.batchimport.input.IdType.INTEGER -> IdType.INTEGER;
            case org.neo4j.gds.compat.batchimport.input.IdType.STRING -> IdType.STRING;
        };
    }

    private static ReadableGroups adaptReadableGroups(org.neo4j.gds.compat.batchimport.input.ReadableGroups groups) {
        return groups == null || groups == org.neo4j.gds.compat.batchimport.input.ReadableGroups.EMPTY ? ReadableGroups.EMPTY : ((ReadableGroupsReverseAdapter)groups).delegate;
    }

    private static org.neo4j.gds.compat.batchimport.input.ReadableGroups adaptReadableGroups(ReadableGroups groups) {
        return groups == null || groups == ReadableGroups.EMPTY ? org.neo4j.gds.compat.batchimport.input.ReadableGroups.EMPTY : new ReadableGroupsReverseAdapter(groups);
    }

    private static Input.Estimates adaptEstimates(Estimates estimates) {
        return estimates == null || estimates == Estimates.NULL ? NULL_ESTIMATES : ((EstimatesAdapter)estimates).delegate;
    }

    static org.neo4j.gds.compat.batchimport.input.ReadableGroups newGroups() {
        return BatchImporterCompat.adaptReadableGroups((ReadableGroups)new Groups());
    }

    static org.neo4j.gds.compat.batchimport.input.ReadableGroups newInitializedGroups() {
        Groups groups = new Groups();
        groups.getOrCreate(null);
        return BatchImporterCompat.adaptReadableGroups((ReadableGroups)groups);
    }

    static org.neo4j.gds.compat.batchimport.input.Collector emptyCollector() {
        return CollectorAdapter.EMPTY;
    }

    static org.neo4j.gds.compat.batchimport.input.Collector badCollector(OutputStream outputStream, int batchSize) {
        return new CollectorAdapter(Collectors.badCollector((OutputStream)outputStream, (long)batchSize));
    }

    static Estimates knownEstimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels) {
        if (numberOfNodes == 0L && numberOfRelationships == 0L && numberOfNodeProperties == 0L && numberOfRelationshipProperties == 0L && sizeOfNodeProperties == 0L && sizeOfRelationshipProperties == 0L && numberOfNodeLabels == 0L) {
            return Estimates.NULL;
        }
        return new EstimatesAdapter(Input.knownEstimates((long)numberOfNodes, (long)numberOfRelationships, (long)numberOfNodeProperties, (long)numberOfRelationshipProperties, (long)sizeOfNodeProperties, (long)sizeOfRelationshipProperties, (long)numberOfNodeLabels));
    }

    static final class ConfigurationAdapter
    implements org.neo4j.batchimport.api.Configuration {
        private final ImportConfig inner;

        ConfigurationAdapter(ImportConfig inner) {
            this.inner = inner;
        }

        public int batchSize() {
            return this.inner.batchSize();
        }

        public int maxNumberOfWorkerThreads() {
            return this.inner.writeConcurrency();
        }

        public boolean highIO() {
            return this.inner.highIO();
        }

        public IndexConfig indexConfig() {
            IndexConfig config = IndexConfig.DEFAULT;
            if (this.inner.createLabelIndex()) {
                config = config.withLabelIndex();
            }
            if (this.inner.createRelationshipTypeIndex()) {
                config = config.withRelationshipTypeIndex();
            }
            return config;
        }
    }

    private static final class MonitorAdapter
    implements Monitor {
        private final org.neo4j.gds.compat.batchimport.Monitor delegate;

        private MonitorAdapter(org.neo4j.gds.compat.batchimport.Monitor delegate) {
            this.delegate = delegate;
        }

        public void started() {
            this.delegate.started();
        }

        public void percentageCompleted(int percentage) {
            this.delegate.percentageCompleted(percentage);
        }

        public void completed(boolean success) {
            this.delegate.completed(success);
        }
    }

    private static final class CollectorAdapter
    implements org.neo4j.gds.compat.batchimport.input.Collector {
        private static final org.neo4j.gds.compat.batchimport.input.Collector EMPTY = new CollectorAdapter(Collector.EMPTY);
        private final Collector delegate;

        CollectorAdapter(Collector delegate) {
            this.delegate = delegate;
        }
    }

    static final class BatchImporterReverseAdapter
    implements BatchImporter {
        private final org.neo4j.batchimport.api.BatchImporter delegate;

        BatchImporterReverseAdapter(org.neo4j.batchimport.api.BatchImporter delegate) {
            this.delegate = delegate;
        }

        public void doImport(org.neo4j.gds.compat.batchimport.input.Input input) throws IOException {
            this.delegate.doImport((Input)new InputAdapter(input));
        }
    }

    private static final class GroupReverseAdapter
    implements org.neo4j.gds.compat.batchimport.input.Group {
        private final Group delegate;

        private GroupReverseAdapter(Group delegate) {
            this.delegate = delegate;
        }
    }

    private static class ReadableGroupsReverseAdapter
    implements org.neo4j.gds.compat.batchimport.input.ReadableGroups {
        private final ReadableGroups delegate;

        ReadableGroupsReverseAdapter(ReadableGroups delegate) {
            this.delegate = delegate;
        }

        public org.neo4j.gds.compat.batchimport.input.Group getGlobalGroup() {
            return BatchImporterCompat.adaptGroup(this.delegate.get(null));
        }
    }

    private static final class EstimatesAdapter
    implements Estimates {
        private final Input.Estimates delegate;

        EstimatesAdapter(Input.Estimates delegate) {
            this.delegate = delegate;
        }
    }

    private static final class InputEntityVisitorReverseAdapter
    implements InputEntityVisitor {
        private final org.neo4j.batchimport.api.input.InputEntityVisitor delegate;

        InputEntityVisitorReverseAdapter(org.neo4j.batchimport.api.input.InputEntityVisitor delegate) {
            this.delegate = delegate;
        }

        public boolean property(String s, Object o) {
            return this.delegate.property(s, o);
        }

        public boolean id(long l) {
            return this.delegate.id(l);
        }

        public boolean id(long id, org.neo4j.gds.compat.batchimport.input.Group group) {
            return this.delegate.id((Object)id, ((GroupReverseAdapter)group).delegate);
        }

        public boolean id(String id, org.neo4j.gds.compat.batchimport.input.Group group) {
            return this.delegate.id((Object)id, ((GroupReverseAdapter)group).delegate);
        }

        public boolean labels(String[] strings) {
            return this.delegate.labels(strings);
        }

        public boolean startId(long l) {
            return this.delegate.startId(l);
        }

        public boolean startId(long id, org.neo4j.gds.compat.batchimport.input.Group group) {
            return this.delegate.startId((Object)id, ((GroupReverseAdapter)group).delegate);
        }

        public boolean startId(String id, org.neo4j.gds.compat.batchimport.input.Group group) {
            return this.delegate.startId((Object)id, ((GroupReverseAdapter)group).delegate);
        }

        public boolean endId(long l) {
            return this.delegate.endId(l);
        }

        public boolean endId(long id, org.neo4j.gds.compat.batchimport.input.Group group) {
            return this.delegate.endId((Object)id, ((GroupReverseAdapter)group).delegate);
        }

        public boolean endId(String id, org.neo4j.gds.compat.batchimport.input.Group group) {
            return this.delegate.endId((Object)id, ((GroupReverseAdapter)group).delegate);
        }

        public boolean type(String s) {
            return this.delegate.type(s);
        }

        public void endOfEntity() throws IOException {
            this.delegate.endOfEntity();
        }

        public void reset() {
            this.delegate.reset();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class InputChunkAdapter
    implements InputChunk {
        private final org.neo4j.gds.compat.batchimport.input.InputChunk delegate;

        private InputChunkAdapter(org.neo4j.gds.compat.batchimport.input.InputChunk delegate) {
            this.delegate = delegate;
        }

        public boolean next(org.neo4j.batchimport.api.input.InputEntityVisitor inputEntityVisitor) throws IOException {
            return this.delegate.next((InputEntityVisitor)new InputEntityVisitorReverseAdapter(inputEntityVisitor));
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    static final class InputIteratorAdapter
    implements org.neo4j.batchimport.api.InputIterator {
        private final InputIterator delegate;

        InputIteratorAdapter(InputIterator delegate) {
            this.delegate = delegate;
        }

        public InputChunk newChunk() {
            return new InputChunkAdapter(this.delegate.newChunk());
        }

        public boolean next(InputChunk inputChunk) throws IOException {
            return this.delegate.next(((InputChunkAdapter)inputChunk).delegate);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    static final class InputIterableAdapter
    implements org.neo4j.batchimport.api.InputIterable {
        private final InputIterable delegate;

        InputIterableAdapter(InputIterable delegate) {
            this.delegate = delegate;
        }

        public org.neo4j.batchimport.api.InputIterator iterator() {
            return new InputIteratorAdapter(this.delegate.iterator());
        }
    }

    static final class InputAdapter
    implements Input {
        private final org.neo4j.gds.compat.batchimport.input.Input delegate;

        InputAdapter(org.neo4j.gds.compat.batchimport.input.Input delegate) {
            this.delegate = delegate;
        }

        public org.neo4j.batchimport.api.InputIterable nodes(Collector collector) {
            return new InputIterableAdapter(this.delegate.nodes());
        }

        public org.neo4j.batchimport.api.InputIterable relationships(Collector collector) {
            return new InputIterableAdapter(this.delegate.relationships());
        }

        public IdType idType() {
            return BatchImporterCompat.adaptIdType(this.delegate.idType());
        }

        public ReadableGroups groups() {
            return BatchImporterCompat.adaptReadableGroups(this.delegate.groups());
        }

        public Input.Estimates calculateEstimates(PropertySizeCalculator propertySizeCalculator) throws IOException {
            return BatchImporterCompat.adaptEstimates(this.delegate.calculateEstimates());
        }

        public void close() {
            this.delegate.close();
        }
    }
}

