/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._523;

import java.io.OutputStream;
import java.util.stream.Stream;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.compat.CompatCallableProcedure;
import org.neo4j.gds.compat.Neo4jProxyApi;
import org.neo4j.gds.compat._523.BatchImporterCompat;
import org.neo4j.gds.compat.batchimport.BatchImporter;
import org.neo4j.gds.compat.batchimport.ImportConfig;
import org.neo4j.gds.compat.batchimport.Monitor;
import org.neo4j.gds.compat.batchimport.input.Collector;
import org.neo4j.gds.compat.batchimport.input.Estimates;
import org.neo4j.gds.compat.batchimport.input.ReadableGroups;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;

public final class Neo4jProxyImpl
implements Neo4jProxyApi {
    public BatchImporter instantiateBatchImporter(DatabaseLayout dbLayout, FileSystemAbstraction fileSystem, ImportConfig config, Monitor monitor, LogService logService, Config dbConfig, JobScheduler jobScheduler, Collector badCollector) {
        return BatchImporterCompat.instantiateBatchImporter(dbLayout, fileSystem, config, monitor, logService, dbConfig, jobScheduler, badCollector);
    }

    public ReadableGroups newGroups() {
        return BatchImporterCompat.newGroups();
    }

    public ReadableGroups newInitializedGroups() {
        return BatchImporterCompat.newInitializedGroups();
    }

    public Collector emptyCollector() {
        return BatchImporterCompat.emptyCollector();
    }

    public Collector badCollector(OutputStream outputStream, int batchSize) {
        return BatchImporterCompat.badCollector(outputStream, batchSize);
    }

    public Estimates knownEstimates(long numberOfNodes, long numberOfRelationships, long numberOfNodeProperties, long numberOfRelationshipProperties, long sizeOfNodeProperties, long sizeOfRelationshipProperties, long numberOfNodeLabels) {
        return BatchImporterCompat.knownEstimates(numberOfNodes, numberOfRelationships, numberOfNodeProperties, numberOfRelationshipProperties, sizeOfNodeProperties, sizeOfRelationshipProperties, numberOfNodeLabels);
    }

    public void rethrowUnlessDuplicateRegistration(ProcedureException e) throws KernelException {
        if (e.status() == Status.Procedure.ProcedureRegistrationFailed && e.getMessage().contains("already in use")) {
            return;
        }
        throw e;
    }

    public CallableProcedure callableProcedure(CompatCallableProcedure procedure) {
        @SuppressForbidden(reason="This is the compat API")
        final class CallableProcedureImpl
        implements CallableProcedure {
            private final CompatCallableProcedure procedure;

            private CallableProcedureImpl(CompatCallableProcedure procedure) {
                this.procedure = procedure;
            }

            public ProcedureSignature signature() {
                return this.procedure.signature();
            }

            public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
                return Iterators.asRawIterator((Stream)this.procedure.apply(ctx, input));
            }
        }
        return new CallableProcedureImpl(procedure);
    }

    public int sequenceSizeAsInt(SequenceValue sequenceValue) {
        return sequenceValue.length();
    }

    public AnyValue sequenceValueAt(SequenceValue sequenceValue, int index) {
        return sequenceValue.value(index);
    }

    public RuntimeException queryExceptionAsRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof QueryExecutionKernelException) {
            return ((QueryExecutionKernelException)throwable).asUserException();
        }
        return new RuntimeException(throwable);
    }

    public ProcedureException procedureCallFailed(String message, Object ... args) {
        return new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, message, args);
    }

    public ProcedureException procedureCallFailed(Throwable reason, String message, Object ... args) {
        return new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, reason, message, args);
    }

    public String exceptionMessage(Throwable e) {
        return e.getMessage();
    }

    public DatabaseNotFoundException databaseNotFoundException(String message) {
        throw new DatabaseNotFoundException(message);
    }
}

