/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._57;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.common.DependencyResolver;
import org.neo4j.gds.compat.BoltTransactionRunner;
import org.neo4j.gds.compat.CompatExecutionContext;
import org.neo4j.gds.compat.GlobalProcedureRegistry;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.StoreScan;
import org.neo4j.gds.compat._57.BoltTransactionRunnerImpl;
import org.neo4j.gds.compat._57.ScanBasedStoreScanImpl;
import org.neo4j.gds.compat._5x.CommonNeo4jProxyImpl;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.procedure.Mode;

public final class Neo4jProxyImpl
extends CommonNeo4jProxyImpl {
    private static final DependencyResolver EMPTY_DEPENDENCY_RESOLVER = new DependencyResolver.Adapter(){

        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
            return null;
        }

        public boolean containsDependency(Class<?> type) {
            return false;
        }
    };

    public long getHighId(RecordStore<? extends AbstractBaseRecord> recordStore) {
        return recordStore.getIdGenerator().getHighId();
    }

    public <T> T lookupComponentProvider(Context ctx, Class<T> component, boolean safe) throws ProcedureException {
        GlobalProcedures globalProcedures = (GlobalProcedures)GraphDatabaseApiProxy.resolveDependency((DependencyResolver)ctx.dependencyResolver(), GlobalProcedures.class);
        return (T)globalProcedures.getCurrentView().lookupComponentProvider(component, safe).apply((Object)ctx);
    }

    public List<StoreScan<NodeLabelIndexCursor>> entityCursorScan(KernelTransaction transaction, int[] labelIds, int batchSize, boolean allowPartitionedScan) {
        if (allowPartitionedScan) {
            return this.partitionedCursorScan(transaction, batchSize, labelIds);
        }
        Read read = transaction.dataRead();
        return Arrays.stream(labelIds).mapToObj(arg_0 -> ((Read)read).nodeLabelScan(arg_0)).map(scan -> new ScanBasedStoreScanImpl(scan, batchSize)).collect(Collectors.toList());
    }

    public StoreScan<NodeLabelIndexCursor> nodeLabelIndexScan(KernelTransaction transaction, int labelId, int batchSize, boolean allowPartitionedScan) {
        if (allowPartitionedScan) {
            return (StoreScan)this.partitionedCursorScan(transaction, batchSize, new int[]{labelId}).get(0);
        }
        Read read = transaction.dataRead();
        Scan scan = read.nodeLabelScan(labelId);
        return new ScanBasedStoreScanImpl<NodeLabelIndexCursor>(scan, batchSize);
    }

    public StoreScan<NodeCursor> nodesScan(KernelTransaction ktx, long nodeCount, int batchSize) {
        return new ScanBasedStoreScanImpl<NodeCursor>(ktx.dataRead().allNodesScan(), batchSize);
    }

    public StoreScan<RelationshipScanCursor> relationshipsScan(KernelTransaction ktx, long relationshipCount, int batchSize) {
        return new ScanBasedStoreScanImpl<RelationshipScanCursor>(ktx.dataRead().allRelationshipsScan(), batchSize);
    }

    public BoltTransactionRunner<?, ?> boltTransactionRunner() {
        return new BoltTransactionRunnerImpl();
    }

    public ProcedureSignature procedureSignature(QualifiedName name, List<FieldSignature> inputSignature, List<FieldSignature> outputSignature, Mode mode, boolean admin, String deprecated, String description, String warning, boolean eager, boolean caseInsensitive, boolean systemProcedure, boolean internal, boolean allowExpiredCredentials, boolean threadSafe) {
        return new ProcedureSignature(name, inputSignature, outputSignature, mode, admin, deprecated, description, warning, eager, caseInsensitive, systemProcedure, internal, allowExpiredCredentials);
    }

    public GlobalProcedureRegistry globalProcedureRegistry(final GlobalProcedures globalProcedures) {
        return new GlobalProcedureRegistry(){

            public Set<ProcedureSignature> getAllProcedures() {
                return globalProcedures.getAllProcedures();
            }

            public Stream<UserFunctionSignature> getAllNonAggregatingFunctions() {
                return globalProcedures.getAllNonAggregatingFunctions();
            }

            public Stream<UserFunctionSignature> getAllAggregatingFunctions() {
                return globalProcedures.getAllAggregatingFunctions();
            }
        };
    }

    public DependencyResolver emptyDependencyResolver() {
        return EMPTY_DEPENDENCY_RESOLVER;
    }

    public CursorContextFactory cursorContextFactory(Optional<PageCacheTracer> pageCacheTracer) {
        return pageCacheTracer.map(cacheTracer -> new CursorContextFactory(cacheTracer, EmptyVersionContextSupplier.EMPTY)).orElse(CursorContextFactory.NULL_CONTEXT_FACTORY);
    }

    public CompatExecutionContext executionContext(KernelTransaction ktx) {
        final Statement stmt = ktx.acquireStatement();
        final ExecutionContext ctx = ktx.createExecutionContext();
        return new CompatExecutionContext(){

            public CursorContext cursorContext() {
                return ctx.cursorContext();
            }

            public AccessMode accessMode() {
                return ctx.securityContext().mode();
            }

            public <C extends Cursor> boolean reservePartition(PartitionedScan<C> scan, C cursor) {
                return scan.reservePartition(cursor, ctx);
            }

            public void close() {
                ctx.complete();
                ctx.close();
                stmt.close();
            }
        };
    }
}

