/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.ResultTransformer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public abstract class GdsGraphDatabaseAPI
implements GraphDatabaseAPI {
    private static final String DB_NAME = "neo4j";
    protected final GraphDatabaseAPI api;
    protected final DatabaseManagementService dbms;

    public GdsGraphDatabaseAPI(DatabaseManagementService dbms) {
        this.api = (GraphDatabaseAPI)dbms.database(DB_NAME);
        this.dbms = dbms;
    }

    public abstract Path dbHome(Path var1);

    public void shutdown() {
        this.dbms.shutdown();
    }

    public DatabaseManagementService dbms() {
        return this.dbms;
    }

    public DependencyResolver getDependencyResolver() {
        return this.api.getDependencyResolver();
    }

    public DatabaseLayout databaseLayout() {
        return this.api.databaseLayout();
    }

    public NamedDatabaseId databaseId() {
        return this.api.databaseId();
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) {
        return this.api.beginTransaction(type, loginContext);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo) {
        return this.api.beginTransaction(type, loginContext, clientInfo);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout, TimeUnit unit) {
        return this.api.beginTransaction(type, loginContext, clientInfo, timeout, unit);
    }

    public boolean isAvailable(long timeout) {
        return this.api.isAvailable(timeout);
    }

    public Transaction beginTx() {
        return this.api.beginTx();
    }

    public Transaction beginTx(long timeout, TimeUnit unit) {
        return this.api.beginTx(timeout, unit);
    }

    public void executeTransactionally(String query) throws QueryExecutionException {
        this.api.executeTransactionally(query);
    }

    public void executeTransactionally(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.api.executeTransactionally(query, parameters);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer) throws QueryExecutionException {
        return (T)this.api.executeTransactionally(query, parameters, resultTransformer);
    }

    public <T> T executeTransactionally(String query, Map<String, Object> parameters, ResultTransformer<T> resultTransformer, Duration timeout) throws QueryExecutionException {
        return (T)this.api.executeTransactionally(query, parameters, resultTransformer, timeout);
    }

    public String databaseName() {
        return this.api.databaseName();
    }
}

