/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public abstract class VirtualRelationship
implements Relationship {
    private final Node startNode;
    private final Node endNode;
    private final RelationshipType type;
    private final long id;
    private final Map<String, Object> props = new HashMap<String, Object>();

    public VirtualRelationship(long id, Node startNode, Node endNode, RelationshipType type) {
        this.id = id;
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public Node getOtherNode(Node node) {
        return node.equals(this.startNode) ? this.endNode : (node.equals(this.endNode) ? this.startNode : null);
    }

    public Node[] getNodes() {
        return new Node[]{this.startNode, this.endNode};
    }

    public RelationshipType getType() {
        return this.type;
    }

    public boolean isType(RelationshipType relationshipType) {
        return relationshipType.name().equals(this.type.name());
    }

    public boolean hasProperty(String s) {
        return this.props.containsKey(s);
    }

    public Object getProperty(String s) {
        return this.props.get(s);
    }

    public Object getProperty(String s, Object o) {
        return this.props.getOrDefault(s, o);
    }

    public void setProperty(String s, Object o) {
        this.props.put(s, o);
    }

    public Object removeProperty(String s) {
        return this.props.remove(s);
    }

    public Iterable<String> getPropertyKeys() {
        return this.props.keySet();
    }

    public Map<String, Object> getProperties(String ... strings) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(this.props);
        res.keySet().retainAll(Arrays.asList(strings));
        return res;
    }

    public Map<String, Object> getAllProperties() {
        return this.props;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Relationship && this.id == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "VirtualRelationship{startNode=" + this.startNode.getLabels() + ", endNode=" + this.endNode.getLabels() + ", type=" + this.type + "}";
    }
}

