/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.gds.api.NodeLookup;
import org.neo4j.gds.compat.VirtualRelationshipImpl;
import org.neo4j.graphalgo.impl.util.PathImpl;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public final class PathFactory {
    private PathFactory() {
    }

    public static Path create(NodeLookup nodeLookup, long[] nodeIds, double[] costs, RelationshipType relationshipType, String costPropertyName) {
        long firstNodeId = nodeIds[0];
        PathImpl.Builder pathBuilder = new PathImpl.Builder(nodeLookup.getNodeById(firstNodeId));
        for (int i = 0; i < nodeIds.length - 1; ++i) {
            long sourceNodeId = nodeIds[i];
            long targetNodeId = nodeIds[i + 1];
            long id = RelationshipIds.next();
            Node startNode = nodeLookup.getNodeById(sourceNodeId);
            Node endNode = nodeLookup.getNodeById(targetNodeId);
            VirtualRelationshipImpl relationship = new VirtualRelationshipImpl(id, startNode, endNode, relationshipType);
            double costDifference = costs[i + 1] - costs[i];
            relationship.setProperty(costPropertyName, (Object)costDifference);
            pathBuilder = pathBuilder.push((Relationship)relationship);
        }
        return pathBuilder.build();
    }

    public static Path create(NodeLookup nodeLookup, List<Long> nodeIds, List<Double> costs, RelationshipType relationshipType, String costPropertyName) {
        Long firstNodeId = nodeIds.get(0);
        PathImpl.Builder pathBuilder = new PathImpl.Builder(nodeLookup.getNodeById(firstNodeId.longValue()));
        int size = nodeIds.size();
        for (int i = 0; i < size - 1; ++i) {
            long sourceNodeId = nodeIds.get(i);
            long targetNodeId = nodeIds.get(i + 1);
            long id = RelationshipIds.next();
            Node startNode = nodeLookup.getNodeById(sourceNodeId);
            Node endNode = nodeLookup.getNodeById(targetNodeId);
            VirtualRelationshipImpl relationship = new VirtualRelationshipImpl(id, startNode, endNode, relationshipType);
            double costDifference = costs.get(i + 1) - costs.get(i);
            relationship.setProperty(costPropertyName, (Object)costDifference);
            pathBuilder = pathBuilder.push((Relationship)relationship);
        }
        return pathBuilder.build();
    }

    public static Path create(NodeLookup nodeLookup, List<Long> nodeIds, RelationshipType relationshipType) {
        Long firstNodeId = nodeIds.get(0);
        PathImpl.Builder pathBuilder = new PathImpl.Builder(nodeLookup.getNodeById(firstNodeId.longValue()));
        for (int i = 0; i < nodeIds.size() - 1; ++i) {
            long sourceNodeId = nodeIds.get(i);
            long targetNodeId = nodeIds.get(i + 1);
            long id = RelationshipIds.next();
            Node startNode = nodeLookup.getNodeById(sourceNodeId);
            Node endNode = nodeLookup.getNodeById(targetNodeId);
            VirtualRelationshipImpl relationship = new VirtualRelationshipImpl(id, startNode, endNode, relationshipType);
            pathBuilder = pathBuilder.push((Relationship)relationship);
        }
        return pathBuilder.build();
    }

    public static final class RelationshipIds {
        static final AtomicLong ids = new AtomicLong(0L);

        static long next() {
            long nextId = ids.getAndDecrement();
            while (nextId > 0L) {
                ids.compareAndSet(nextId - 1L, 0L);
                nextId = ids.getAndDecrement();
            }
            return nextId;
        }

        @TestOnly
        public static void set(long value) {
            ids.set(value);
        }

        private RelationshipIds() {
        }
    }
}

