/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.algorithms.pathfinding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.NodeLookup;
import org.neo4j.gds.procedures.algorithms.pathfinding.StandardStreamPathCreator;
import org.neo4j.graphdb.Path;

public final class BellmanFordStreamResult {
    public long index;
    public long sourceNode;
    public long targetNode;
    public double totalCost;
    public List<Long> nodeIds;
    public List<Double> costs;
    public Path route;
    public boolean isNegativeCycle;

    public BellmanFordStreamResult(long index, long sourceNode, long targetNode, double totalCost, List<Long> nodeIds, List<Double> costs, Path route, boolean isNegativeCycle) {
        this.index = index;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.totalCost = totalCost;
        this.nodeIds = nodeIds;
        this.costs = costs;
        this.route = route;
        this.isNegativeCycle = isNegativeCycle;
    }

    public static class Builder {
        private final IdMap idMap;
        private final NodeLookup nodeLookup;
        private boolean isCycle;

        public Builder(IdMap idMap, NodeLookup nodeLookup) {
            this.idMap = idMap;
            this.nodeLookup = nodeLookup;
        }

        public Builder withIsCycle(boolean isCycle) {
            this.isCycle = isCycle;
            return this;
        }

        public BellmanFordStreamResult build(long[] nodeIds, double[] costs, long pathIndex, long sourceNode, long targetNode, double totalCost, boolean createCypherPath) {
            for (int i = 0; i < nodeIds.length; ++i) {
                nodeIds[i] = this.idMap.toOriginalNodeId(nodeIds[i]);
            }
            Path path = null;
            if (createCypherPath) {
                path = StandardStreamPathCreator.create(this.nodeLookup, nodeIds, costs, pathIndex);
            }
            return new BellmanFordStreamResult(pathIndex, this.idMap.toOriginalNodeId(sourceNode), this.idMap.toOriginalNodeId(targetNode), totalCost, Arrays.stream(nodeIds).boxed().collect(Collectors.toCollection(() -> new ArrayList(nodeIds.length))), Arrays.stream(costs).boxed().collect(Collectors.toCollection(() -> new ArrayList(costs.length))), path, this.isCycle);
        }
    }
}

