/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.algorithms.pathfinding;

import java.util.List;
import org.neo4j.gds.api.NodeLookup;
import org.neo4j.gds.paths.PathFactory;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;

public final class StandardStreamPathCreator {
    private static final String COST_PROPERTY_NAME = "cost";
    private static final String RELATIONSHIP_TYPE_TEMPLATE = "PATH_%d";

    private StandardStreamPathCreator() {
    }

    public static Path create(NodeLookup nodeLookup, long[] nodeIds, double[] costs, long pathIndex) {
        RelationshipType relationshipType = RelationshipType.withName((String)StringFormatting.formatWithLocale((String)RELATIONSHIP_TYPE_TEMPLATE, (Object[])new Object[]{pathIndex}));
        return PathFactory.create(nodeLookup, nodeIds, costs, relationshipType, COST_PROPERTY_NAME);
    }

    public static Path create(NodeLookup nodeLookup, List<Long> nodeIds, List<Double> costs, long pathIndex) {
        RelationshipType relationshipType = RelationshipType.withName((String)StringFormatting.formatWithLocale((String)RELATIONSHIP_TYPE_TEMPLATE, (Object[])new Object[]{pathIndex}));
        return PathFactory.create(nodeLookup, nodeIds, costs, relationshipType, COST_PROPERTY_NAME);
    }
}

