/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.procedures.algorithms.pathfinding;

import java.util.Map;
import org.neo4j.gds.procedures.algorithms.pathfinding.SteinerStatsResult;
import org.neo4j.gds.result.AbstractResultBuilder;

public final class SteinerWriteResult
extends SteinerStatsResult {
    public final long writeMillis;
    public final long relationshipsWritten;

    public SteinerWriteResult(long preProcessingMillis, long computeMillis, long writeMillis, long effectiveNodeCount, long effectiveTargetNodesCount, double totalCost, long relationshipsWritten, Map<String, Object> configuration) {
        super(preProcessingMillis, computeMillis, effectiveNodeCount, effectiveTargetNodesCount, totalCost, configuration);
        this.writeMillis = writeMillis;
        this.relationshipsWritten = relationshipsWritten;
    }

    public static class Builder
    extends AbstractResultBuilder<SteinerWriteResult> {
        long effectiveNodeCount;
        long effectiveTargetNodesCount;
        double totalWeight;

        public Builder withEffectiveNodeCount(long effectiveNodeCount) {
            this.effectiveNodeCount = effectiveNodeCount;
            return this;
        }

        public Builder withEffectiveTargetNodeCount(long effectiveTargetNodesCount) {
            this.effectiveTargetNodesCount = effectiveTargetNodesCount;
            return this;
        }

        public Builder withTotalWeight(double totalWeight) {
            this.totalWeight = totalWeight;
            return this;
        }

        public SteinerWriteResult build() {
            return new SteinerWriteResult(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.effectiveNodeCount, this.effectiveTargetNodesCount, this.totalWeight, this.relationshipsWritten, this.config.toMap());
        }
    }
}

