/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.core.model.Model;

public class MLTrainResult {
    public final long trainMillis;
    public final Map<String, Object> modelInfo;
    public final Map<String, Object> configuration;

    public MLTrainResult(Optional<Model<?, ?, ?>> maybeTrainedModel, long trainMillis) {
        if (maybeTrainedModel.isPresent()) {
            Model<?, ?, ?> trainedModel = maybeTrainedModel.get();
            this.modelInfo = Stream.concat(Map.of("modelName", trainedModel.name(), "modelType", trainedModel.algoType()).entrySet().stream(), trainedModel.customInfo().toMap().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.configuration = trainedModel.trainConfig().toMap();
        } else {
            this.modelInfo = Collections.emptyMap();
            this.configuration = Collections.emptyMap();
        }
        this.trainMillis = trainMillis;
    }
}

