/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.linkmodels.pipeline;

import java.util.List;
import java.util.Map;
import org.neo4j.gds.core.model.Model;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.ml.api.TrainingMethod;
import org.neo4j.gds.ml.models.Classifier;
import org.neo4j.gds.ml.pipeline.linkPipeline.LinkPredictionModelInfo;
import org.neo4j.gds.ml.pipeline.linkPipeline.train.LinkPredictionTrainConfig;

public final class LinkPredictionPipelineCompanion {
    public static final String PREDICT_DESCRIPTION = "Predicts relationships for all non-connected node pairs based on a previously trained LinkPrediction model.";
    public static final String ESTIMATE_PREDICT_DESCRIPTION = "Estimates memory for predicting relationships for all non-connected node pairs based on a previously trained LinkPrediction model";
    static final Map<String, List<Map<String, Object>>> DEFAULT_PARAM_SPACE = Map.of(TrainingMethod.LogisticRegression.toString(), List.of(), TrainingMethod.RandomForestClassification.toString(), List.of(), TrainingMethod.MLPClassification.toString(), List.of());

    private LinkPredictionPipelineCompanion() {
    }

    public static Model<Classifier.ClassifierData, LinkPredictionTrainConfig, LinkPredictionModelInfo> getTrainedLPPipelineModel(ModelCatalog modelCatalog, String pipelineName, String username) {
        return modelCatalog.get(username, pipelineName, Classifier.ClassifierData.class, LinkPredictionTrainConfig.class, LinkPredictionModelInfo.class);
    }
}

