/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.ml.pipeline.node.NodePropertyPredictPipelineFilterUtil;

@ParametersAreNonnullByDefault
@Generated(from="NodePropertyPredictPipelineFilterUtil.PredictGraphFilter", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutablePredictGraphFilter
implements NodePropertyPredictPipelineFilterUtil.PredictGraphFilter {
    private final List<String> nodeLabels;
    private final List<String> relationshipTypes;

    private ImmutablePredictGraphFilter(Iterable<String> nodeLabels, Iterable<String> relationshipTypes) {
        this.nodeLabels = ImmutablePredictGraphFilter.createUnmodifiableList(false, ImmutablePredictGraphFilter.createSafeList(nodeLabels, true, false));
        this.relationshipTypes = ImmutablePredictGraphFilter.createUnmodifiableList(false, ImmutablePredictGraphFilter.createSafeList(relationshipTypes, true, false));
    }

    private ImmutablePredictGraphFilter(ImmutablePredictGraphFilter original, List<String> nodeLabels, List<String> relationshipTypes) {
        this.nodeLabels = nodeLabels;
        this.relationshipTypes = relationshipTypes;
    }

    @Override
    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    @Override
    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public final ImmutablePredictGraphFilter withNodeLabels(String ... elements) {
        List<String> newValue = ImmutablePredictGraphFilter.createUnmodifiableList(false, ImmutablePredictGraphFilter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePredictGraphFilter(this, newValue, this.relationshipTypes);
    }

    public final ImmutablePredictGraphFilter withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutablePredictGraphFilter.createUnmodifiableList(false, ImmutablePredictGraphFilter.createSafeList(elements, true, false));
        return new ImmutablePredictGraphFilter(this, newValue, this.relationshipTypes);
    }

    public final ImmutablePredictGraphFilter withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutablePredictGraphFilter.createUnmodifiableList(false, ImmutablePredictGraphFilter.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePredictGraphFilter(this, this.nodeLabels, newValue);
    }

    public final ImmutablePredictGraphFilter withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutablePredictGraphFilter.createUnmodifiableList(false, ImmutablePredictGraphFilter.createSafeList(elements, true, false));
        return new ImmutablePredictGraphFilter(this, this.nodeLabels, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePredictGraphFilter && this.equalTo(0, (ImmutablePredictGraphFilter)another);
    }

    private boolean equalTo(int synthetic, ImmutablePredictGraphFilter another) {
        return this.nodeLabels.equals(another.nodeLabels) && this.relationshipTypes.equals(another.relationshipTypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        return h;
    }

    public String toString() {
        return "PredictGraphFilter{nodeLabels=" + this.nodeLabels + ", relationshipTypes=" + this.relationshipTypes + "}";
    }

    public static NodePropertyPredictPipelineFilterUtil.PredictGraphFilter of(List<String> nodeLabels, List<String> relationshipTypes) {
        return ImmutablePredictGraphFilter.of(nodeLabels, relationshipTypes);
    }

    public static NodePropertyPredictPipelineFilterUtil.PredictGraphFilter of(Iterable<String> nodeLabels, Iterable<String> relationshipTypes) {
        return new ImmutablePredictGraphFilter(nodeLabels, relationshipTypes);
    }

    public static NodePropertyPredictPipelineFilterUtil.PredictGraphFilter copyOf(NodePropertyPredictPipelineFilterUtil.PredictGraphFilter instance) {
        if (instance instanceof ImmutablePredictGraphFilter) {
            return (ImmutablePredictGraphFilter)instance;
        }
        return ImmutablePredictGraphFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="NodePropertyPredictPipelineFilterUtil.PredictGraphFilter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<String> nodeLabels = null;
        private List<String> relationshipTypes = null;

        private Builder() {
        }

        public final Builder from(NodePropertyPredictPipelineFilterUtil.PredictGraphFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllNodeLabels(instance.nodeLabels());
            this.addAllRelationshipTypes(instance.relationshipTypes());
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            return this;
        }

        public Builder clear() {
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            return this;
        }

        public NodePropertyPredictPipelineFilterUtil.PredictGraphFilter build() {
            return new ImmutablePredictGraphFilter(null, this.nodeLabels == null ? Collections.emptyList() : ImmutablePredictGraphFilter.createUnmodifiableList(true, this.nodeLabels), this.relationshipTypes == null ? Collections.emptyList() : ImmutablePredictGraphFilter.createUnmodifiableList(true, this.relationshipTypes));
        }
    }
}

