/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.ml.pipeline.node.classification;

import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.ml.pipeline.node.NodePipelineInfoResult;
import org.neo4j.gds.ml.pipeline.nodePipeline.NodePropertyTrainingPipeline;
import org.neo4j.gds.ml.pipeline.nodePipeline.classification.NodeClassificationTrainingPipeline;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class NodeClassificationPipelineCreateProc
extends BaseProc {
    public static NodePipelineInfoResult create(String username, String pipelineName) {
        StringIdentifierValidations.validateNoWhiteCharacter((String)pipelineName, (String)"pipelineName");
        NodeClassificationTrainingPipeline pipeline = new NodeClassificationTrainingPipeline();
        PipelineCatalog.set((String)username, (String)pipelineName, (TrainingPipeline)pipeline);
        return new NodePipelineInfoResult(pipelineName, (NodePropertyTrainingPipeline)pipeline);
    }

    @Procedure(name="gds.beta.pipeline.nodeClassification.create", mode=Mode.READ)
    @Description(value="Creates a node classification training pipeline in the pipeline catalog.")
    public Stream<NodePipelineInfoResult> create(@Name(value="pipelineName") String pipelineName) {
        return Stream.of(NodeClassificationPipelineCreateProc.create(this.username(), pipelineName));
    }
}

